/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.python;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.DefaultKnowledgeHelper;
import org.drools.spi.Functions;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.parser;
import org.python.parser.ast.modType;

public class PythonInterp {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private final Rule rule;
    private final String text;
    private final String origininalText;
    private final PyCode code;
    private final modType node;
    private PyDictionary globals;
    static /* synthetic */ Class class$org$drools$semantics$python$PythonImportEntry;
    static /* synthetic */ Class class$org$drools$semantics$python$PythonInterp;

    protected PythonInterp(String text, Rule rule, String type) {
        this.rule = rule;
        this.origininalText = text;
        StringBuffer globalText = new StringBuffer();
        Iterator it = rule.getImports(class$org$drools$semantics$python$PythonImportEntry == null ? (class$org$drools$semantics$python$PythonImportEntry = PythonInterp.class$("org.drools.semantics.python.PythonImportEntry")) : class$org$drools$semantics$python$PythonImportEntry).iterator();
        while (it.hasNext()) {
            globalText.append(it.next());
            globalText.append(";");
            globalText.append(LINE_SEPARATOR);
        }
        globalText.append("def q(cond,on_true,on_false):\n");
        globalText.append("  if cond:\n");
        globalText.append("    return on_true\n");
        globalText.append("  else:\n");
        globalText.append("    return on_false\n");
        Functions functions = rule.getRuleSet().getFunctions("python");
        if (functions != null) {
            globalText.append(PythonInterp.stripOuterIndention(functions.getText()));
        }
        if (this.globals == null) {
            this.globals = this.getGlobals(globalText.toString());
        }
        this.text = PythonInterp.stripOuterIndention(text);
        try {
            this.node = (modType)parser.parse((String)this.text, (String)type);
            this.code = Py.compile((modType)this.node, (String)"<jython>");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public PyDictionary getGlobals(String text) {
        PyModule module = new PyModule("main", (PyObject)new PyDictionary());
        PyObject locals = module.__dict__;
        Py.exec((PyObject)Py.compile_flags((String)text, (String)"<string>", (String)"exec", null), (PyObject)locals, (PyObject)locals);
        return (PyDictionary)locals;
    }

    protected static String stripOuterIndention(String text) {
        try {
            if (null == text) {
                return null;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(text.getBytes())));
            StringBuffer unindentedText = new StringBuffer(text.length());
            int lineNo = 0;
            try {
                String indent = null;
                String line = br.readLine();
                while (null != line) {
                    ++lineNo;
                    if ("".equals(line.trim())) {
                        unindentedText.append(line + LINE_SEPARATOR);
                    } else {
                        if (null == indent) {
                            indent = line.substring(0, line.indexOf(line.trim()));
                        }
                        if (line.length() < indent.length() || !line.startsWith(indent)) {
                            throw new RuntimeException("Bad Text Indention: Line " + lineNo + ": |" + PythonInterp.formatForException(line) + "|" + LINE_SEPARATOR + PythonInterp.formatForException(text));
                        }
                        if (line.startsWith(indent)) {
                            unindentedText.append(line.substring(indent.length()));
                        }
                        unindentedText.append(LINE_SEPARATOR);
                    }
                    line = br.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            if (unindentedText.length() > 0) {
                unindentedText.deleteCharAt(unindentedText.length() - 1);
            }
            return unindentedText.toString();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e.getMessage());
        }
    }

    private static String formatForException(String text) {
        StringBuffer sbuf = new StringBuffer(text.length() * 2);
        int max = text.length();
        for (int i = 0; i < max; ++i) {
            char nextChar = text.charAt(i);
            if ('\t' == nextChar) {
                sbuf.append("{{tab}}");
                continue;
            }
            sbuf.append(nextChar);
        }
        return sbuf.toString();
    }

    public String getText() {
        return this.origininalText;
    }

    protected Rule getRule() {
        return this.rule;
    }

    protected PyCode getCode() {
        return this.code;
    }

    protected modType getNode() {
        return this.node;
    }

    protected PyDictionary getGlobals() {
        return this.globals;
    }

    protected PyDictionary setUpDictionary(Tuple tuple, Iterator declIter) throws Exception {
        PyDictionary dict = new PyDictionary();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = (class$org$drools$semantics$python$PythonInterp == null ? (class$org$drools$semantics$python$PythonInterp = PythonInterp.class$("org.drools.semantics.python.PythonInterp")) : class$org$drools$semantics$python$PythonInterp).getClassLoader();
        }
        while (declIter.hasNext()) {
            int dotPosition;
            int nestedClassPosition;
            String type;
            Class<?> clazz;
            Declaration eachDecl = (Declaration)declIter.next();
            dict.setdefault((PyObject)new PyString(eachDecl.getIdentifier().intern()), Py.java2py((Object)tuple.get(eachDecl)));
            ObjectType objectType = eachDecl.getObjectType();
            if (objectType instanceof ClassObjectType) {
                clazz = ((ClassObjectType)objectType).getType();
                type = clazz.getName();
                nestedClassPosition = type.indexOf(36);
                if (nestedClassPosition != -1) {
                    type = type.substring(0, nestedClassPosition);
                    clazz = cl.loadClass(type);
                }
                if (type.indexOf("java.lang") == -1) {
                    dotPosition = type.lastIndexOf(46);
                    if (dotPosition != -1) {
                        type = type.substring(dotPosition + 1);
                    }
                    dict.setdefault((PyObject)new PyString(type.intern()), Py.java2py(clazz));
                }
            }
            WorkingMemory workingMemory = tuple.getWorkingMemory();
            dict.setdefault((PyObject)new PyString("drools".intern()), Py.java2py((Object)new DefaultKnowledgeHelper(this.rule, tuple)));
            Map appDataMap = workingMemory.getApplicationDataMap();
            Iterator keyIter = appDataMap.keySet().iterator();
            while (keyIter.hasNext()) {
                String key = (String)keyIter.next();
                Object value = appDataMap.get(key);
                dict.setdefault((PyObject)new PyString(key.intern()), Py.java2py(value));
                clazz = value.getClass();
                type = clazz.getName();
                nestedClassPosition = type.indexOf(36);
                if (nestedClassPosition != -1) {
                    type = type.substring(0, nestedClassPosition);
                    clazz = cl.loadClass(type);
                }
                if (type.indexOf("java.lang") != -1) continue;
                dotPosition = type.lastIndexOf(46);
                if (dotPosition != -1) {
                    type = type.substring(dotPosition + 1);
                }
                dict.setdefault((PyObject)new PyString(type.intern()), Py.java2py(clazz));
            }
        }
        return dict;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PySystemState.initialize();
        PySystemState systemState = Py.getSystemState();
        if (systemState == null) {
            systemState = new PySystemState();
        }
        Py.setSystemState((PySystemState)systemState);
    }
}

