/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway.rules;

import java.util.ArrayList;
import org.drools.examples.conway.Cell;
import org.drools.rule.Declaration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.semantics.base.ClassObjectType;
import org.drools.smf.ConditionFactory;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.spi.Condition;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public class ConwayConditionFactory
implements ConditionFactory {
    static /* synthetic */ Class class$org$drools$examples$conway$Cell;

    public Condition[] newCondition(Rule rule, RuleBaseContext context, Configuration config) throws FactoryException {
        Configuration childConfig = null;
        Configuration[] configurations = config.getChildren();
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (int i = 0; i < configurations.length; ++i) {
            childConfig = configurations[i];
            if (!childConfig.getName().equals("cell")) continue;
            conditions.add(this.processCell(rule, childConfig));
        }
        return conditions.toArray(new Condition[conditions.size()]);
    }

    private Condition processCell(Rule rule, Configuration config) throws FactoryException {
        Condition condition = null;
        Configuration[] children = config.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Configuration childConfig = children[i];
            String cellName = config.getAttribute("name");
            final Declaration cellDeclaration = this.getDeclaration(rule, class$org$drools$examples$conway$Cell == null ? ConwayConditionFactory.class$("org.drools.examples.conway.Cell") : class$org$drools$examples$conway$Cell, cellName);
            final Declaration[] declarations = new Declaration[]{cellDeclaration};
            final int numberOfNeighbors = Integer.parseInt(childConfig.getText());
            if (childConfig.getName().equals("liveNeighborCountGreaterThan")) {
                condition = new Condition(){

                    public Declaration[] getRequiredTupleMembers() {
                        return declarations;
                    }

                    public boolean isAllowed(Tuple tuple) {
                        Cell cell = (Cell)tuple.get(cellDeclaration);
                        int n = cell.getNumberOfLiveNeighbors();
                        boolean isAllowed = n > numberOfNeighbors;
                        return isAllowed;
                    }
                };
                continue;
            }
            if (childConfig.getName().equals("liveNeighborCountLessThan")) {
                condition = new Condition(){

                    public Declaration[] getRequiredTupleMembers() {
                        return declarations;
                    }

                    public boolean isAllowed(Tuple tuple) {
                        Cell cell = (Cell)tuple.get(cellDeclaration);
                        int n = cell.getNumberOfLiveNeighbors();
                        boolean isAllowed = n < numberOfNeighbors;
                        return isAllowed;
                    }
                };
                continue;
            }
            if (!childConfig.getName().equals("liveNeighborCountEquals")) continue;
            condition = new Condition(){

                public Declaration[] getRequiredTupleMembers() {
                    return declarations;
                }

                public boolean isAllowed(Tuple tuple) {
                    Cell cell = (Cell)tuple.get(cellDeclaration);
                    int n = cell.getNumberOfLiveNeighbors();
                    boolean isAllowed = n == numberOfNeighbors;
                    return isAllowed;
                }
            };
        }
        return condition;
    }

    private Declaration getDeclaration(Rule rule, Class clazz, String identifier) throws FactoryException {
        Declaration declaration = rule.getParameterDeclaration(identifier);
        if (declaration == null) {
            ClassObjectType type = new ClassObjectType(clazz);
            try {
                declaration = rule.addParameterDeclaration(identifier, type);
            }
            catch (InvalidRuleException e) {
                throw new FactoryException("xxx");
            }
        }
        return declaration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

