/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.Scheduler;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.AgendaFilter;
import org.drools.spi.AsyncExceptionHandler;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Duration;
import org.drools.spi.Tuple;
import org.drools.util.PriorityQueue;

class Agenda
implements Serializable {
    public static int NONE = 0;
    public static int ASSERT = 1;
    public static int MODIFY = 2;
    public static int RETRACT = 3;
    private final WorkingMemoryImpl workingMemory;
    private final PriorityQueue activationQueue;
    private final Map scheduledItems;
    private final Map itemsToRetract;
    private final Map scheduledItemsToRetract;
    private AgendaItem item;
    private int mode = 0;

    public Agenda(WorkingMemoryImpl workingMemory, ConflictResolver conflictResolver) {
        this.workingMemory = workingMemory;
        this.activationQueue = new PriorityQueue(conflictResolver);
        this.scheduledItems = new HashMap();
        this.itemsToRetract = new HashMap();
        this.scheduledItemsToRetract = new HashMap();
    }

    void addToAgenda(ReteTuple tuple, Rule rule) {
        if (this.item != null && rule.getNoLoop() && rule.equals(this.item.getRule())) {
            return;
        }
        Duration dur = rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            AgendaItem item = null;
            if (!this.itemsToRetract.isEmpty()) {
                item = (AgendaItem)this.scheduledItems.get(tuple.getKey());
            }
            if (item == null) {
                item = new AgendaItem(tuple, rule);
                this.scheduledItems.put(item.getKey(), item);
                this.scheduleItem(item);
                this.workingMemory.getEventSupport().fireActivationCreated(rule, tuple);
            }
        } else {
            AgendaItem item = null;
            if (!this.itemsToRetract.isEmpty()) {
                item = (AgendaItem)this.itemsToRetract.remove(tuple.getKey());
            }
            if (item == null) {
                item = new AgendaItem(tuple, rule);
                this.activationQueue.add(item);
                this.workingMemory.getEventSupport().fireActivationCreated(rule, tuple);
            } else {
                this.activationQueue.add(item);
            }
        }
    }

    void removeFromAgenda(TupleKey key, Rule rule) {
        AgendaItem eachItem;
        Iterator itemIter = this.activationQueue.iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            itemIter.remove();
            itemIter = this.activationQueue.iterator();
            if (this.mode == MODIFY && !this.workingMemory.getEventSupport().isEmpty()) {
                this.itemsToRetract.put(eachItem.getKey(), eachItem);
                continue;
            }
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, eachItem.getTuple());
        }
        itemIter = this.scheduledItems.values().iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            if (this.mode == MODIFY && !this.workingMemory.getEventSupport().isEmpty()) {
                this.scheduledItemsToRetract.put(eachItem.getKey(), eachItem);
                continue;
            }
            Tuple tuple = eachItem.getTuple();
            this.cancelItem(eachItem);
            itemIter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(rule, tuple);
        }
    }

    void removeMarkedItemsFromAgenda() {
        AgendaItem eachItem;
        Iterator itemIter = this.itemsToRetract.values().iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
            itemIter.remove();
        }
        itemIter = this.scheduledItemsToRetract.values().iterator();
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            this.cancelItem(eachItem);
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
            itemIter.remove();
        }
    }

    void clearAgenda() {
        AgendaItem eachItem;
        Iterator iter = this.activationQueue.iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
        iter = this.scheduledItems.values().iterator();
        while (iter.hasNext()) {
            eachItem = (AgendaItem)iter.next();
            this.cancelItem(eachItem);
            iter.remove();
            this.workingMemory.getEventSupport().fireActivationCancelled(eachItem.getRule(), eachItem.getTuple());
        }
    }

    void scheduleItem(AgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item, this.workingMemory);
    }

    void cancelItem(AgendaItem item) {
        Scheduler.getInstance().cancelAgendaItem(item);
    }

    public boolean isEmpty() {
        return this.activationQueue.isEmpty();
    }

    public int size() {
        return this.activationQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireNextItem(AgendaFilter filter) throws ConsequenceException {
        if (this.isEmpty()) {
            return;
        }
        this.item = (AgendaItem)this.activationQueue.remove();
        try {
            if (filter == null || filter.accept(this.item)) {
                this.item.fire(this.workingMemory);
            }
        }
        finally {
            this.item = null;
        }
    }

    void setAsyncExceptionHandler(AsyncExceptionHandler handler) {
        Scheduler.getInstance().setAsyncExceptionHandler(handler);
    }

    void setMode(int mode) {
        this.mode = mode;
    }
}

