/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Arrays;
import org.drools.FactHandle;
import org.drools.reteoo.FactHandleImpl;

final class FactHandleList
implements Serializable {
    static final FactHandleList EMPTY_LIST = new FactHandleList();
    private final FactHandle[] handles;
    private final int hashCode;

    private FactHandleList() {
        this.handles = new FactHandleImpl[0];
        this.hashCode = 0;
    }

    public FactHandleList(FactHandleList left, FactHandleList right) {
        this.handles = new FactHandle[Math.max(left.handles.length, right.handles.length)];
        System.arraycopy(left.handles, 0, this.handles, 0, left.handles.length);
        int hashCode = left.hashCode;
        for (int i = right.handles.length - 1; i >= 0; --i) {
            FactHandle handle = right.handles[i];
            if (handle == null || this.handles[i] != null) continue;
            this.handles[i] = handle;
            hashCode += handle.hashCode();
        }
        this.hashCode = hashCode;
    }

    public FactHandleList(int index, FactHandle handle) {
        this.handles = new FactHandleImpl[index + 1];
        this.handles[index] = handle;
        this.hashCode = handle.hashCode();
    }

    public FactHandle get(int index) {
        return this.handles[index];
    }

    public boolean contains(FactHandle handle) {
        for (int i = this.handles.length - 1; i >= 0; --i) {
            if (!handle.equals(this.handles[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(FactHandleList other) {
        if (other.handles.length > this.handles.length) {
            return false;
        }
        for (int i = other.handles.length - 1; i >= 0; --i) {
            FactHandle handle = other.handles[i];
            if (handle == null || handle.equals(this.handles[i])) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.handles.length;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.handles, ((FactHandleList)object).handles);
    }
}

