/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.RetractionException;
import org.drools.reteoo.JoinNodeInput;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;

class JoinNode
extends TupleSource {
    private final TupleSource leftInput;
    private final TupleSource rightInput;
    private final Set tupleDeclarations;
    private final Set commonDeclarations;

    public JoinNode(TupleSource leftInput, TupleSource rightInput) {
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.tupleDeclarations = this.determineTupleDeclarations();
        this.commonDeclarations = this.determineCommonDeclarations();
    }

    private Set determineCommonDeclarations() {
        HashSet commonDeclarations = new HashSet(this.leftInput.getTupleDeclarations());
        commonDeclarations.retainAll(this.rightInput.getTupleDeclarations());
        return commonDeclarations.isEmpty() ? Collections.EMPTY_SET : Collections.unmodifiableSet(commonDeclarations);
    }

    public Set getCommonDeclarations() {
        return this.commonDeclarations;
    }

    private void propagateAssertTuples(TupleSet joinedTuples, WorkingMemoryImpl workingMemory) throws AssertionException {
        Iterator tupleIter = joinedTuples.iterator();
        while (tupleIter.hasNext()) {
            this.propagateAssertTuple((ReteTuple)tupleIter.next(), workingMemory);
        }
    }

    void assertLeftTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        TupleSet joinedTuples = workingMemory.getJoinMemory(this).addLeftTuple(tuple);
        if (!joinedTuples.isEmpty()) {
            this.propagateAssertTuples(joinedTuples, workingMemory);
        }
    }

    void assertRightTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        TupleSet joinedTuples = workingMemory.getJoinMemory(this).addRightTuple(tuple);
        if (!joinedTuples.isEmpty()) {
            this.propagateAssertTuples(joinedTuples, workingMemory);
        }
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        if (workingMemory.getJoinMemory(this).removeTuples(key)) {
            this.propagateRetractTuples(key, workingMemory);
        }
    }

    public Set getTupleDeclarations() {
        return this.tupleDeclarations;
    }

    public void attach() {
        this.leftInput.addTupleSink(new JoinNodeInput(this, 41));
        this.rightInput.addTupleSink(new JoinNodeInput(this, 42));
    }

    private Set determineTupleDeclarations() {
        HashSet decls = new HashSet(this.leftInput.getTupleDeclarations());
        decls.addAll(this.rightInput.getTupleDeclarations());
        return Collections.unmodifiableSet(decls);
    }

    public String toString() {
        return "[JoinNode: common=" + this.commonDeclarations + "; decls=" + this.tupleDeclarations + "]";
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JoinNode other = (JoinNode)object;
        return this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput);
    }
}

