/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.annotation.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import org.drools.rule.Rule;
import org.drools.semantics.annotation.model.ParameterValue;
import org.drools.spi.Tuple;

class RuleReflectMethod
implements Externalizable {
    private Rule rule;
    private Object pojo;
    private Method method;
    private ParameterValue[] parameterValues;

    public RuleReflectMethod() {
    }

    public RuleReflectMethod(Rule rule, Object pojo, Method method, ParameterValue[] parameterValues) {
        this.rule = rule;
        this.pojo = pojo;
        this.method = method;
        this.parameterValues = parameterValues;
    }

    public ParameterValue[] getParameterValues() {
        return this.parameterValues;
    }

    public Object invokeMethod(Tuple tuple) throws Exception {
        this.method.setAccessible(true);
        return this.method.invoke(this.pojo, this.getMethodArguments(tuple));
    }

    private Object[] getMethodArguments(Tuple tuple) {
        Object[] args = new Object[this.parameterValues.length];
        for (int i = 0; i < this.parameterValues.length; ++i) {
            args[i] = this.parameterValues[i].getValue(tuple);
        }
        return args;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.pojo);
        out.writeObject(this.method.getName());
        out.writeObject(this.method.getParameterTypes());
        out.writeObject(this.parameterValues);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.pojo = in.readObject();
        String methodName = (String)in.readObject();
        Class[] parameterTypes = (Class[])in.readObject();
        try {
            this.method = this.pojo.getClass().getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.parameterValues = (ParameterValue[])in.readObject();
    }

    public String toString() {
        return this.pojo.getClass().getSimpleName() + "." + this.method.getName() + "(" + this.toStringParamterTypes() + ")";
    }

    private String toStringParamterTypes() {
        return "...";
    }
}

