/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.groovy;

import groovy.lang.Binding;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.semantics.groovy.GroovyExprAnalyzer;
import org.drools.semantics.groovy.GroovyInterp;
import org.drools.semantics.groovy.NonBooleanExprException;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Tuple;

public class GroovyCondition
extends GroovyInterp
implements Condition {
    private Declaration[] requiredDeclarations;

    public GroovyCondition(String text, Rule rule) throws Exception {
        super(text, rule);
        GroovyExprAnalyzer analyzer = new GroovyExprAnalyzer();
        this.requiredDeclarations = analyzer.analyze(this.getText(), rule.getParameterDeclarations());
    }

    public Object evaluate(Tuple tuple) {
        Binding dict = this.setUpDictionary(tuple, this.declarationIterator());
        return this.evaluate(dict);
    }

    protected Object evaluate(Binding locals) {
        this.getCode().setBinding(locals);
        return this.getCode().run();
    }

    public Declaration[] getRequiredTupleMembers() {
        return this.requiredDeclarations;
    }

    public boolean isAllowed(Tuple tuple) throws ConditionException {
        try {
            Object answer = this.evaluate(tuple);
            if (!(answer instanceof Boolean)) {
                throw new NonBooleanExprException(this.getText());
            }
            return (Boolean)answer;
        }
        catch (RuntimeException e) {
            throw new ConditionException(e, this.getRule(), this.getText());
        }
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.getText().equals(((GroovyInterp)object).getText());
    }

    public Iterator declarationIterator() {
        return new Iterator(){
            private int index = 0;

            public void remove() {
            }

            public boolean hasNext() {
                return this.index < GroovyCondition.this.requiredDeclarations.length;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return GroovyCondition.this.requiredDeclarations[this.index++];
            }
        };
    }
}

