/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.MockWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.smf.ConditionFactory;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DefaultConfiguration;
import org.drools.smf.DefaultImporter;
import org.drools.smf.DefaultSemanticsRepository;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsRepository;
import org.drools.spi.Condition;
import org.drools.spi.ConditionException;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Importer;
import org.drools.spi.MockTuple;
import org.drools.spi.ObjectType;
import org.drools.spi.RuleBaseContext;
import org.drools.spi.Tuple;

public abstract class SMFTestFrameWork
extends TestCase {
    private List tests;
    private String testType;
    private SemanticModule module;
    private SemanticsRepository repository;
    private String newline = System.getProperty("line.separator");
    private Importer importer;
    private RuleBaseContext ruleBaseContext;
    static /* synthetic */ Class class$org$drools$smf$SMFTestFrameWork$Cheese;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$HashMap;

    public SMFTestFrameWork(String name) {
        super(name);
        this.testType = name.substring(4).toLowerCase();
    }

    public void setUp(String semantic, Importer importer) throws Exception {
        if (!"conditions".equals(this.testType) && !"consequences".equals(this.testType)) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL semanticTests = cl.getResource("data/" + semantic + "-" + this.testType + ".data");
        BufferedReader in = new BufferedReader(new InputStreamReader(semanticTests.openStream()));
        StringBuffer buffer = new StringBuffer();
        String blockMarker = "<!--drools-test--!>";
        this.tests = new ArrayList();
        while (in.ready()) {
            String line = in.readLine() + this.newline;
            if (line.startsWith(blockMarker)) {
                this.tests.add(buffer.toString());
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(line);
        }
        this.tests.add(buffer.toString());
        this.repository = DefaultSemanticsRepository.getInstance();
        this.module = this.repository.lookupSemanticModule("http://drools.org/semantics/" + semantic);
        this.importer = importer;
        this.ruleBaseContext = new RuleBaseContext();
    }

    public void testConditions() throws Exception {
        int testNumber = 0;
        DefaultConfiguration cheeseConfiguration = new DefaultConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        RuleSet ruleSet = new RuleSet("test RuleSet", this.ruleBaseContext);
        Rule rule = new Rule("Test Rule 1", ruleSet);
        rule.setImporter(new DefaultImporter());
        ObjectType cheeseType = objectTypeFactory.newObjectType(rule, this.ruleBaseContext, cheeseConfiguration);
        MockTuple tuple = new MockTuple();
        rule.setImporter(new DefaultImporter());
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        Declaration camembertDecl = rule.addParameterDeclaration("camembert", cheeseType);
        Declaration stiltonDecl = rule.addParameterDeclaration("stilton", cheeseType);
        rule.setImporter(this.importer);
        tuple.put(camembertDecl, new Cheese("camembert"));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        tuple.put(camembertDecl, new Cheese("camembert"));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("favouriteCheese", new Cheese("camembert"));
        tuple.setWorkingMemory(workingMemory);
        HashMap<String, Class> applicationData = new HashMap<String, Class>();
        applicationData.put("bites", class$java$lang$Integer == null ? (class$java$lang$Integer = SMFTestFrameWork.class$("java.lang.Integer")) : class$java$lang$Integer);
        applicationData.put("favouriteCheese", class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese);
        rule.setApplicationData(applicationData);
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertFalse((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        tuple = new MockTuple();
        rule.setImporter(this.importer);
        rule.setApplicationData(new HashMap());
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        DefaultConfiguration stringConfiguration = new DefaultConfiguration("test2");
        stringConfiguration.setText((class$java$lang$String == null ? (class$java$lang$String = SMFTestFrameWork.class$("java.lang.String")) : class$java$lang$String).getName());
        ObjectType stringType = objectTypeFactory.newObjectType(rule, this.ruleBaseContext, stringConfiguration);
        Declaration favouriteCheeseDecl = rule.addParameterDeclaration("favouriteCheese", stringType);
        tuple.put(favouriteCheeseDecl, "camembert");
        tuple.put(camembertDecl, new Cheese("camembert"));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        try {
            this.testCondition(testNumber++, tuple, rule);
            SMFTestFrameWork.fail((String)"Condition should throw an exception");
        }
        catch (ConditionException e) {
            SMFTestFrameWork.assertEquals((Object)rule, (Object)e.getRule());
            SMFTestFrameWork.assertEquals(this.tests.get(testNumber - 1), (Object)e.getInfo());
        }
        tuple = new MockTuple();
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        SMFTestFrameWork.assertTrue((boolean)this.testCondition(testNumber++, tuple, rule));
    }

    private boolean testCondition(int testNumber, Tuple tuple, Rule rule) throws Exception {
        ConditionFactory conditionFactory = this.module.getConditionFactory("condition");
        DefaultConfiguration conditionConfiguration = new DefaultConfiguration("test" + testNumber);
        conditionConfiguration.setText((String)this.tests.get(testNumber));
        Condition condition = conditionFactory.newCondition(rule, this.ruleBaseContext, conditionConfiguration)[0];
        return condition.isAllowed(tuple);
    }

    public void testConsequences() throws Exception {
        DefaultConfiguration cheeseConfiguration = new DefaultConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        RuleSet ruleSet = new RuleSet("test RuleSet", this.ruleBaseContext);
        Rule rule = new Rule("Test Rule 1", ruleSet);
        rule.setImporter(new DefaultImporter());
        ObjectType cheeseType = objectTypeFactory.newObjectType(rule, this.ruleBaseContext, cheeseConfiguration);
        MockTuple tuple = new MockTuple();
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        tuple.setWorkingMemory(new MockWorkingMemory());
        this.testConsequence(0, tuple, rule);
        Declaration camembertDecl = rule.addParameterDeclaration("camembert", cheeseType);
        Declaration stiltonDecl = rule.addParameterDeclaration("stilton", cheeseType);
        Cheese camembert = new Cheese("camembert");
        Cheese stilton = new Cheese("stilton");
        tuple.put(camembertDecl, camembert);
        tuple.put(stiltonDecl, stilton);
        this.testConsequence(1, tuple, rule);
        SMFTestFrameWork.assertEquals((int)3, (int)camembert.getBitesLeft());
        SMFTestFrameWork.assertEquals((int)3, (int)stilton.getBitesLeft());
        this.testConsequence(2, tuple, rule);
        SMFTestFrameWork.assertEquals((int)2, (int)camembert.getBitesLeft());
        SMFTestFrameWork.assertEquals((int)1, (int)stilton.getBitesLeft());
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("cheeses", new HashMap());
        HashMap<String, Class> applicationData = new HashMap<String, Class>();
        applicationData.put("bites", class$java$lang$Integer == null ? (class$java$lang$Integer = SMFTestFrameWork.class$("java.lang.Integer")) : class$java$lang$Integer);
        applicationData.put("cheeses", class$java$util$HashMap == null ? (class$java$util$HashMap = SMFTestFrameWork.class$("java.util.HashMap")) : class$java$util$HashMap);
        rule.setApplicationData(applicationData);
        tuple.setWorkingMemory(workingMemory);
        this.testConsequence(3, tuple, rule);
        SMFTestFrameWork.assertEquals((int)1, (int)camembert.getBitesLeft());
        SMFTestFrameWork.assertEquals((int)0, (int)stilton.getBitesLeft());
        Map map = (Map)workingMemory.getApplicationData("cheeses");
        SMFTestFrameWork.assertEquals((Object)camembert, map.get("favourite cheese"));
        SMFTestFrameWork.assertEquals((int)3, (int)((Integer)map.get("bites")));
        rule = new Rule("Test Rule 1", ruleSet);
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        try {
            this.testConsequence(6, tuple, rule);
            SMFTestFrameWork.fail((String)"Consequence should throw an exception");
        }
        catch (ConsequenceException e) {
            SMFTestFrameWork.assertEquals((Object)rule, (Object)e.getRule());
        }
        tuple = new MockTuple();
        rule = new Rule("Test Rule 1", ruleSet);
        rule.setImporter(this.importer);
        tuple.setRule(rule);
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        try {
            this.testConsequence(7, tuple, rule);
        }
        catch (ConsequenceException e) {
            SMFTestFrameWork.fail((String)"Consequence should execute without errors");
        }
    }

    private void testConsequence(int testNumber, Tuple tuple, Rule rule) throws Exception {
        ConsequenceFactory consequenceFactory = this.module.getConsequenceFactory("consequence");
        DefaultConfiguration consequenceConfiguration = new DefaultConfiguration("test" + testNumber);
        consequenceConfiguration.setText((String)this.tests.get(testNumber));
        Consequence consequence = consequenceFactory.newConsequence(rule, this.ruleBaseContext, consequenceConfiguration);
        consequence.invoke(tuple);
    }

    public static boolean conditionExceptionTest() throws Exception {
        throw new Exception("this is a condition exception");
    }

    public static void consequenceExceptionTest() throws Exception {
        throw new Exception("this is a consequence exception");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Cheese {
        private String name;
        private int bitesLeft = 3;

        public Cheese(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void eatCheese() {
            --this.bitesLeft;
        }

        public int getBitesLeft() {
            return this.bitesLeft;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            return this.name.equals(((Cheese)object).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

