/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.conway;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.examples.conway.CellState;

public class Cell {
    private Set neighbors = new HashSet();
    private CellState state = CellState.DEAD;
    private CellState queuedState = null;

    public int getNumberOfNeighboringCells() {
        return this.neighbors.size();
    }

    public int getNumberOfLiveNeighbors() {
        int numberOfLiveNeighbors = 0;
        Iterator it = this.neighbors.iterator();
        Cell cell = null;
        while (it.hasNext()) {
            cell = (Cell)it.next();
            if (cell.getCellState() != CellState.LIVE) continue;
            ++numberOfLiveNeighbors;
        }
        return numberOfLiveNeighbors;
    }

    public void addNeighbor(Cell neighbor) {
        this.neighbors.add(neighbor);
        neighbor.neighbors.add(this);
    }

    public void queueNextCellState(CellState nextLiveState) {
        if (nextLiveState != this.state) {
            this.queuedState = nextLiveState;
        }
    }

    public boolean transitionState() {
        boolean stateChanged = false;
        if (this.queuedState != null) {
            this.state = this.queuedState;
            this.queuedState = null;
            stateChanged = true;
        }
        return stateChanged;
    }

    public CellState getCellState() {
        return this.state;
    }

    public void setCellState(CellState newState) {
        this.state = newState;
    }
}

