/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.control.rules;

import org.drools.examples.jiahvac.model.HeatPump;
import org.drools.examples.jiahvac.model.TempuratureControl;
import org.drools.examples.jiahvac.model.Thermometer;
import org.drools.examples.jiahvac.model.Vent;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.DroolsRule;

@DroolsRule
public class CoolingVentOpenFloorCoolEnough {
    @DroolsCondition
    public boolean isPumpCooling(@DroolsParameter(value="pump") HeatPump pump) {
        return pump.getState() == HeatPump.State.COOLING;
    }

    @DroolsCondition
    public boolean isVentOpen(@DroolsParameter(value="vent") Vent vent) {
        return vent.getState() == Vent.State.OPEN;
    }

    @DroolsCondition
    public boolean isSameFloor(@DroolsParameter(value="vent") Vent vent, @DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="pump") HeatPump pump) {
        return vent.getFloor() == thermometer.getFloor() && vent.getFloor().getHeatPump() == pump;
    }

    @DroolsCondition
    public boolean isCoolEnough(@DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="control") TempuratureControl control) {
        return control.isCoolEnough(thermometer.getReading());
    }

    @DroolsConsequence
    public void consequence(@DroolsParameter(value="vent") Vent vent) {
        vent.setState(Vent.State.CLOSED);
        System.out.println("CoolingVentOpenFloorCoolEnough: " + vent + ", " + vent.getFloor().getThermometer());
    }
}

