/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.jiahvac.control.rules;

import org.drools.examples.jiahvac.model.HeatPump;
import org.drools.examples.jiahvac.model.TempuratureControl;
import org.drools.examples.jiahvac.model.Thermometer;
import org.drools.semantics.annotation.DroolsCondition;
import org.drools.semantics.annotation.DroolsConsequence;
import org.drools.semantics.annotation.DroolsParameter;
import org.drools.semantics.annotation.DroolsRule;

@DroolsRule
public class FloorTooColdPumpOff {
    @DroolsCondition
    public boolean isPumpOff(@DroolsParameter(value="pump") HeatPump pump) {
        return pump.getState() == HeatPump.State.OFF;
    }

    @DroolsCondition
    public boolean isPumpServicingFloor(@DroolsParameter(value="pump") HeatPump pump, @DroolsParameter(value="thermometer") Thermometer thermometer) {
        return thermometer.getFloor().getHeatPump() == pump;
    }

    @DroolsCondition
    public boolean isTooCold(@DroolsParameter(value="thermometer") Thermometer thermometer, @DroolsParameter(value="control") TempuratureControl control) {
        return control.isTooCold(thermometer.getReading());
    }

    @DroolsConsequence
    public void consequence(@DroolsParameter(value="pump") HeatPump pump) {
        pump.setState(HeatPump.State.HEATING);
        System.out.println("FloorTooColdPumpOff: " + pump);
    }
}

