/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.ObjectType;

class ObjectTypeNode
implements Serializable {
    private final ObjectType objectType;
    private final List parameterNodes = new ArrayList(1);

    public ObjectTypeNode(ObjectType objectType) {
        this.objectType = objectType;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    void addParameterNode(ParameterNode node) {
        if (!this.parameterNodes.contains(node)) {
            this.parameterNodes.add(node);
        }
    }

    Collection getParameterNodes() {
        return this.parameterNodes;
    }

    Iterator getParameterNodeIterator() {
        return Collections.unmodifiableList(this.parameterNodes).iterator();
    }

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        if (!this.objectType.matches(object)) {
            return;
        }
        int size = this.parameterNodes.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterNode)this.parameterNodes.get(i)).assertObject(handle, object, workingMemory);
        }
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws FactException {
        if (!this.objectType.matches(workingMemory.getObject(handle))) {
            return;
        }
        int size = this.parameterNodes.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterNode)this.parameterNodes.get(i)).retractObject(handle, workingMemory);
        }
    }
}

