/*
 * Decompiled with CFR 0.152.
 */
package org.drools.semantics.base;

import org.drools.rule.Rule;
import org.drools.semantics.base.ClassFieldObjectType;
import org.drools.smf.Configuration;
import org.drools.smf.FactoryException;
import org.drools.smf.ObjectTypeFactory;
import org.drools.spi.ObjectType;
import org.drools.spi.RuleBaseContext;

public class SemaphoreFactory
implements ObjectTypeFactory {
    private static final SemaphoreFactory INSTANCE = new SemaphoreFactory();

    public static SemaphoreFactory getInstance() {
        return INSTANCE;
    }

    public ObjectType newObjectType(Rule rule, RuleBaseContext context, Configuration config) throws FactoryException {
        String className = config.getAttribute("type");
        String fieldName = "identifier";
        String fieldValue = config.getAttribute("identifier");
        if (className == null || className.trim().equals("")) {
            throw new FactoryException("no Semaphore type specified");
        }
        className = "org.drools.semantics.base." + className + "Semaphore";
        if (fieldValue == null || fieldValue.trim().equals("")) {
            throw new FactoryException("no Semaphore identifier specified");
        }
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            Class<?> clazz = null;
            try {
                clazz = cl.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new FactoryException("Unable create Semaphore for type '" + config.getAttribute("type") + "'");
            }
            clazz.getMethod("get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1), null);
            return new ClassFieldObjectType(clazz, fieldName, fieldValue);
        }
        catch (SecurityException e) {
            throw new FactoryException("Field '" + fieldName + "' is not accessible for Class '" + className + "'");
        }
        catch (NoSuchMethodException e) {
            throw new FactoryException("Field '" + fieldName + "' does not exist for Class '" + className + "'");
        }
    }
}

