/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.Condition;

class ConditionNode
extends TupleSource
implements TupleSink,
Serializable {
    private Condition condition;
    private TupleSource tupleSource;

    ConditionNode(TupleSource tupleSource, Condition condition) {
        this.condition = condition;
        this.tupleSource = tupleSource;
        if (tupleSource != null) {
            this.tupleSource.setTupleSink(this);
        }
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Set getTupleDeclarations() {
        return this.tupleSource.getTupleDeclarations();
    }

    public void assertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        if (this.getCondition().isAllowed(tuple)) {
            this.propagateAssertTuple(tuple, workingMemory);
        }
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        this.propagateRetractTuples(key, workingMemory);
    }

    public void modifyTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        HashSet<TupleKey> retractedKeys = new HashSet<TupleKey>();
        Iterator tupleIter = newTuples.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            if (this.getCondition().isAllowed(eachTuple)) continue;
            tupleIter.remove();
            retractedKeys.add(eachTuple.getKey());
        }
        Iterator keyIter = retractedKeys.iterator();
        TupleKey eachKey = null;
        while (keyIter.hasNext()) {
            eachKey = (TupleKey)keyIter.next();
            this.propagateRetractTuples(eachKey, workingMemory);
        }
        if (newTuples.size() != 0) {
            this.propagateModifyTuples(trigger, newTuples, workingMemory);
        }
    }

    public String toString() {
        return "[ConditionNodeImpl: cond=" + this.condition + "]";
    }
}

