/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.JoinMemory;
import org.drools.reteoo.JoinNodeInput;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;

class JoinNode
extends TupleSource
implements Serializable {
    private TupleSource leftInput;
    private TupleSource rightInput;
    private Set commonDeclarations;

    public JoinNode(TupleSource leftInput, TupleSource rightInput) {
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.determineCommonDeclarations();
        leftInput.setTupleSink(this.getLeftNodeInput());
        rightInput.setTupleSink(this.getRightNodeInput());
    }

    public String toString() {
        return "[JoinNode: common=" + this.commonDeclarations + "; decls=" + this.getTupleDeclarations() + "]";
    }

    private void determineCommonDeclarations() {
        this.commonDeclarations = new HashSet();
        Set leftDecls = this.leftInput.getTupleDeclarations();
        Set rightDecls = this.rightInput.getTupleDeclarations();
        Iterator declIter = rightDecls.iterator();
        Declaration eachDecl = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            if (!leftDecls.contains(eachDecl)) continue;
            this.commonDeclarations.add(eachDecl);
        }
    }

    public Set getCommonDeclarations() {
        return this.commonDeclarations;
    }

    public TupleSource getLeftInput() {
        return this.leftInput;
    }

    public TupleSource getRightInput() {
        return this.rightInput;
    }

    void propagateAssertTuples(Set joinedTuples, WorkingMemoryImpl workingMemory) throws AssertionException {
        Iterator tupleIter = joinedTuples.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            this.propagateAssertTuple(eachTuple, workingMemory);
        }
    }

    void assertLeftTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        Set joinedTuples = memory.addLeftTuple(this, tuple);
        if (joinedTuples.isEmpty()) {
            return;
        }
        this.propagateAssertTuples(joinedTuples, workingMemory);
    }

    void assertRightTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        Set joinedTuples = memory.addRightTuple(this, tuple);
        if (joinedTuples.isEmpty()) {
            return;
        }
        this.propagateAssertTuples(joinedTuples, workingMemory);
    }

    JoinNodeInput getLeftNodeInput() {
        return new JoinNodeInput(this, 41);
    }

    JoinNodeInput getRightNodeInput() {
        return new JoinNodeInput(this, 42);
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        memory.retractTuples(key);
        this.propagateRetractTuples(key, workingMemory);
    }

    void modifyLeftTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        memory.modifyLeftTuples(trigger, newTuples, this, workingMemory);
    }

    void modifyRightTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        JoinMemory memory = workingMemory.getJoinMemory(this);
        memory.modifyRightTuples(trigger, newTuples, this, workingMemory);
    }

    public Set getTupleDeclarations() {
        HashSet decls = new HashSet();
        decls.addAll(this.getLeftInput().getTupleDeclarations());
        decls.addAll(this.getRightInput().getTupleDeclarations());
        return decls;
    }
}

