/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.ObjectType;

class Rete
implements Serializable {
    private Map objectTypeNodes = Collections.EMPTY_MAP;

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.assertObject(handle, object, workingMemory);
        }
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws FactException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.retractObject(handle, workingMemory);
        }
    }

    void modifyObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        Iterator nodeIter = this.getObjectTypeNodeIterator();
        ObjectTypeNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ObjectTypeNode)nodeIter.next();
            eachNode.modifyObject(handle, object, workingMemory);
        }
    }

    void addObjectTypeNode(ObjectTypeNode node) {
        if (this.objectTypeNodes == Collections.EMPTY_MAP) {
            this.objectTypeNodes = new HashMap();
        }
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    Collection getObjectTypeNodes() {
        return this.objectTypeNodes.values();
    }

    Iterator getObjectTypeNodeIterator() {
        return this.objectTypeNodes.values().iterator();
    }

    ObjectTypeNode getObjectTypeNode(ObjectType objectType) {
        return (ObjectTypeNode)this.objectTypeNodes.get(objectType);
    }

    ObjectTypeNode getOrCreateObjectTypeNode(ObjectType objectType) {
        ObjectTypeNode node = this.getObjectTypeNode(objectType);
        if (node == null) {
            node = new ObjectTypeNode(objectType);
            this.addObjectTypeNode(node);
        }
        return node;
    }
}

