/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.NoSuchFactObjectException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.conflict.SalienceConflictResolver;
import org.drools.reteoo.Agenda;
import org.drools.reteoo.DefaultFactHandleFactory;
import org.drools.reteoo.FactHandleFactory;
import org.drools.reteoo.JoinMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.spi.ConflictResolver;

class WorkingMemoryImpl
implements WorkingMemory {
    private static final String JSR_FACT_HANDLE_FACTORY_NAME = "org.drools.jsr94.rules.Jsr94FactHandleFactory";
    private RuleBaseImpl ruleBase;
    private Map joinMemories;
    private Agenda agenda;
    private boolean firing;
    private Object applicationData;
    private Map objects;
    private FactHandleFactory factHandleFactory;

    public WorkingMemoryImpl(RuleBaseImpl ruleBase) {
        this(ruleBase, SalienceConflictResolver.getInstance());
    }

    public WorkingMemoryImpl(RuleBaseImpl ruleBase, ConflictResolver conflictResolver) {
        this.ruleBase = ruleBase;
        this.joinMemories = new HashMap();
        this.objects = new HashMap();
        this.agenda = new Agenda(this, conflictResolver);
        this.initializeFactHandleFactory();
    }

    protected void initializeFactHandleFactory() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> jsrHandleFactoryClass = null;
        try {
            jsrHandleFactoryClass = cl.loadClass(JSR_FACT_HANDLE_FACTORY_NAME);
        }
        catch (ClassNotFoundException e) {
            cl = this.getClass().getClassLoader();
            try {
                jsrHandleFactoryClass = cl.loadClass(JSR_FACT_HANDLE_FACTORY_NAME);
            }
            catch (ClassNotFoundException e2) {
                // empty catch block
            }
            try {
                this.factHandleFactory = (FactHandleFactory)jsrHandleFactoryClass.newInstance();
            }
            catch (Exception e2) {
                this.factHandleFactory = null;
            }
        }
        if (this.factHandleFactory == null) {
            this.factHandleFactory = new DefaultFactHandleFactory();
        }
    }

    protected FactHandle newFactHandle() {
        return this.factHandleFactory.newFactHandle();
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public void setApplicationData(Object appData) {
        this.applicationData = appData;
    }

    protected Agenda getAgenda() {
        return this.agenda;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fireAllRules() throws FactException {
        if (!this.firing) {
            Agenda agenda = this.getAgenda();
            try {
                this.firing = true;
                while (!agenda.isEmpty()) {
                    agenda.fireNextItem();
                }
                Object var3_2 = null;
                this.firing = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.firing = false;
                throw throwable;
            }
        }
    }

    public Object getObject(FactHandle handle) throws NoSuchFactObjectException {
        if (!this.objects.containsKey(handle)) {
            throw new NoSuchFactObjectException(handle);
        }
        return this.objects.get(handle);
    }

    public List getObjects() {
        return new ArrayList(this.objects.values());
    }

    public boolean containsObject(FactHandle handle) {
        return this.objects.containsKey(handle);
    }

    public synchronized FactHandle assertObject(Object object) throws FactException {
        FactHandle handle = this.newFactHandle();
        this.ruleBase.assertObject(handle, object, this);
        this.putObject(handle, object);
        return handle;
    }

    void putObject(FactHandle handle, Object object) {
        this.objects.put(handle, object);
    }

    public synchronized void retractObject(FactHandle handle) throws FactException {
        this.ruleBase.retractObject(handle, this);
        this.objects.remove(handle);
    }

    public synchronized void modifyObject(FactHandle handle, Object object) throws FactException {
        if (!this.containsObject(handle)) {
            throw new NoSuchFactObjectException(handle);
        }
        this.ruleBase.modifyObject(handle, object, this);
        this.objects.put(handle, object);
    }

    public JoinMemory getJoinMemory(JoinNode node) {
        JoinMemory memory = (JoinMemory)this.joinMemories.get(node);
        if (memory == null) {
            memory = new JoinMemory(node);
            this.joinMemories.put(node, memory);
        }
        return memory;
    }
}

