/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.RuleBase;
import org.drools.RuleIntegrationException;
import org.drools.conflict.SalienceConflictResolver;
import org.drools.reteoo.ConditionNode;
import org.drools.reteoo.ExtractionNode;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.Rete;
import org.drools.reteoo.RuleBaseImpl;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.TupleSource;
import org.drools.rule.Declaration;
import org.drools.rule.Extraction;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.spi.Condition;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ObjectType;

public class Builder {
    private Rete rete = new Rete();
    private List ruleSets = new ArrayList();
    private ConflictResolver conflictResolver = SalienceConflictResolver.getInstance();

    public Rete getRete() {
        return this.rete;
    }

    public RuleBase buildRuleBase() {
        RuleBaseImpl ruleBase = new RuleBaseImpl(this.getRete(), this.ruleSets.toArray(RuleSet.EMPTY_ARRAY), this.conflictResolver);
        this.rete = null;
        this.ruleSets.clear();
        this.conflictResolver = SalienceConflictResolver.getInstance();
        return ruleBase;
    }

    public void setConflictResolver(ConflictResolver conflictResolver) {
        this.conflictResolver = conflictResolver;
    }

    public void addRuleSet(RuleSet ruleSet) throws RuleIntegrationException {
        this.ruleSets.add(ruleSet);
        Rule[] rules = ruleSet.getRules();
        int i = 0;
        while (i < rules.length) {
            this.addRule(ruleSet, rules[i]);
            ++i;
        }
    }

    protected void addRule(RuleSet ruleSet, Rule rule) throws RuleIntegrationException {
        HashSet<Extraction> factExtracts = new HashSet<Extraction>(Arrays.asList(rule.getExtractions()));
        ArrayList<Condition> conds = new ArrayList<Condition>(Arrays.asList(rule.getConditions()));
        Set leafNodes = null;
        boolean performedJoin = false;
        boolean attachedExtract = false;
        boolean joinedForCondition = false;
        leafNodes = this.createParameterNodes(rule);
        while (true) {
            performedJoin = false;
            attachedExtract = false;
            joinedForCondition = false;
            if (!conds.isEmpty()) {
                this.attachConditions(conds, leafNodes);
            }
            attachedExtract = this.attachExtractions(factExtracts, leafNodes);
            performedJoin = this.createJoinNodes(leafNodes);
            if (!(performedJoin || attachedExtract || conds.isEmpty())) {
                joinedForCondition = this.joinForCondition(conds, leafNodes);
            }
            if (joinedForCondition || (performedJoin || attachedExtract) && leafNodes.size() > 1) continue;
            if (leafNodes.size() > 1) {
                this.joinArbitrary(leafNodes);
                continue;
            }
            if (!attachedExtract) break;
        }
        if (leafNodes.size() != 1) {
            throw new RuleIntegrationException(rule);
        }
        TupleSource lastNode = (TupleSource)leafNodes.iterator().next();
        TerminalNode terminal = new TerminalNode(lastNode, rule);
    }

    Set createParameterNodes(Rule rule) {
        HashSet<ParameterNode> leafNodes = new HashSet<ParameterNode>();
        HashSet<Declaration> parameterDecls = new HashSet<Declaration>(Arrays.asList(rule.getParameterDeclarations()));
        Iterator declIter = parameterDecls.iterator();
        Declaration eachDecl = null;
        ObjectType objectType = null;
        ObjectTypeNode objectTypeNode = null;
        ParameterNode paramNode = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            objectType = eachDecl.getObjectType();
            objectTypeNode = this.getRete().getOrCreateObjectTypeNode(objectType);
            paramNode = new ParameterNode(objectTypeNode, eachDecl);
            leafNodes.add(paramNode);
        }
        return leafNodes;
    }

    void attachConditions(List conds, Set leafNodes) {
        Iterator condIter = conds.iterator();
        Condition eachCond = null;
        TupleSource tupleSource = null;
        ConditionNode conditionNode = null;
        while (condIter.hasNext()) {
            eachCond = (Condition)condIter.next();
            tupleSource = this.findMatchingTupleSourceForCondition(eachCond, leafNodes);
            if (tupleSource == null) continue;
            condIter.remove();
            conditionNode = new ConditionNode(tupleSource, eachCond);
            leafNodes.remove(tupleSource);
            leafNodes.add(conditionNode);
        }
    }

    boolean joinForCondition(List conds, Set leafNodes) {
        return this.joinArbitrary(leafNodes);
    }

    boolean joinArbitrary(Set leafNodes) {
        Iterator leafIter = leafNodes.iterator();
        TupleSource left = (TupleSource)leafIter.next();
        if (!leafIter.hasNext()) {
            return false;
        }
        leafIter.remove();
        TupleSource right = (TupleSource)leafIter.next();
        leafIter.remove();
        JoinNode joinNode = new JoinNode(left, right);
        leafNodes.add(joinNode);
        return true;
    }

    boolean createJoinNodes(Set leafNodes) {
        boolean performedJoin = false;
        Object[] leftNodes = leafNodes.toArray();
        Object[] rightNodes = leafNodes.toArray();
        TupleSource left = null;
        TupleSource right = null;
        JoinNode joinNode = null;
        int i = 0;
        while (i < leftNodes.length) {
            left = (TupleSource)leftNodes[i];
            if (leafNodes.contains(left)) {
                int j = i + 1;
                while (j < rightNodes.length) {
                    right = (TupleSource)rightNodes[j];
                    if (leafNodes.contains(right) && this.canBeJoined(left, right)) {
                        joinNode = new JoinNode(left, right);
                        leafNodes.remove(left);
                        leafNodes.remove(right);
                        leafNodes.add(joinNode);
                        performedJoin = true;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return performedJoin;
    }

    boolean canBeJoined(TupleSource left, TupleSource right) {
        Set leftDecls = left.getTupleDeclarations();
        Iterator rightDeclIter = right.getTupleDeclarations().iterator();
        while (rightDeclIter.hasNext()) {
            if (!leftDecls.contains(rightDeclIter.next())) continue;
            return true;
        }
        return false;
    }

    boolean attachExtractions(Set factExtracts, Set leafNodes) {
        boolean attached = false;
        boolean cycleAttached = false;
        do {
            cycleAttached = false;
            Iterator extractIter = factExtracts.iterator();
            Extraction eachExtract = null;
            TupleSource tupleSource = null;
            ExtractionNode extractNode = null;
            while (extractIter.hasNext()) {
                eachExtract = (Extraction)extractIter.next();
                tupleSource = this.findMatchingTupleSourceForExtraction(eachExtract, leafNodes);
                if (tupleSource == null) continue;
                extractIter.remove();
                extractNode = new ExtractionNode(tupleSource, eachExtract.getTargetDeclaration(), eachExtract.getExtractor());
                leafNodes.remove(tupleSource);
                leafNodes.add(extractNode);
                cycleAttached = true;
            }
            if (!cycleAttached) continue;
            attached = true;
        } while (cycleAttached);
        return attached;
    }

    TupleSource findMatchingTupleSourceForCondition(Condition condition, Set sources) {
        Iterator sourceIter = sources.iterator();
        TupleSource eachSource = null;
        Set decls = null;
        while (sourceIter.hasNext()) {
            eachSource = (TupleSource)sourceIter.next();
            decls = eachSource.getTupleDeclarations();
            if (!this.matches(condition, decls)) continue;
            return eachSource;
        }
        return null;
    }

    TupleSource findMatchingTupleSourceForExtraction(Extraction extract, Set sources) {
        Declaration targetDecl = extract.getTargetDeclaration();
        Iterator sourceIter = sources.iterator();
        TupleSource eachSource = null;
        Set decls = null;
        while (sourceIter.hasNext()) {
            eachSource = (TupleSource)sourceIter.next();
            decls = eachSource.getTupleDeclarations();
            if (decls.contains(targetDecl) || !this.matches(extract, decls)) continue;
            return eachSource;
        }
        return null;
    }

    boolean matches(Condition condition, Set declarations) {
        return this.matches(condition.getRequiredTupleMembers(), declarations);
    }

    boolean matches(Extraction extract, Set declarations) {
        return this.matches(extract.getRequiredTupleMembers(), declarations);
    }

    boolean matches(Declaration[] requiredDecls, Set declarations) {
        int i = 0;
        while (i < requiredDecls.length) {
            if (!declarations.contains(requiredDecls[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

