/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.reteoo.ParameterNode;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.spi.ObjectType;

class ObjectTypeNode
implements Serializable {
    private ObjectType objectType;
    private Set parameterNodes;

    public ObjectTypeNode(ObjectType objectType) {
        this.objectType = objectType;
        this.parameterNodes = Collections.EMPTY_SET;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    void addParameterNode(ParameterNode node) {
        if (this.parameterNodes == Collections.EMPTY_SET) {
            this.parameterNodes = new HashSet();
        }
        this.parameterNodes.add(node);
    }

    Set getParameterNodes() {
        return this.parameterNodes;
    }

    Iterator getParameterNodeIterator() {
        return this.parameterNodes.iterator();
    }

    void assertObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        ObjectType objectType = this.getObjectType();
        if (!objectType.matches(object)) {
            return;
        }
        Iterator nodeIter = this.getParameterNodeIterator();
        ParameterNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ParameterNode)nodeIter.next();
            eachNode.assertObject(handle, object, workingMemory);
        }
    }

    void retractObject(FactHandle handle, WorkingMemoryImpl workingMemory) throws FactException {
        Object object = workingMemory.getObject(handle);
        ObjectType objectType = this.getObjectType();
        if (!objectType.matches(object)) {
            return;
        }
        Iterator nodeIter = this.getParameterNodeIterator();
        ParameterNode eachNode = null;
        while (nodeIter.hasNext()) {
            eachNode = (ParameterNode)nodeIter.next();
            eachNode.retractObject(handle, workingMemory);
        }
    }

    /*
     * Unable to fully structure code
     */
    void modifyObject(FactHandle handle, Object object, WorkingMemoryImpl workingMemory) throws FactException {
        block2: {
            objectType = this.getObjectType();
            nodeIter = this.getParameterNodeIterator();
            eachNode = null;
            if (objectType.matches(object)) ** GOTO lbl12
            while (nodeIter.hasNext()) {
                eachNode = (ParameterNode)nodeIter.next();
                eachNode.retractObject(handle, workingMemory);
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                eachNode = (ParameterNode)nodeIter.next();
                eachNode.modifyObject(handle, object, workingMemory);
lbl12:
                // 2 sources

                ** while (nodeIter.hasNext())
            }
        }
    }
}

