/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.WorkingMemoryImpl;

abstract class TupleSource {
    private TupleSink tupleSink;

    TupleSource() {
    }

    protected void setTupleSink(TupleSink tupleSink) {
        this.tupleSink = tupleSink;
    }

    protected void propagateAssertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        TupleSink sink = this.getTupleSink();
        if (sink != null) {
            sink.assertTuple(tuple, workingMemory);
        }
    }

    protected void propagateRetractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        TupleSink sink = this.getTupleSink();
        if (sink != null) {
            sink.retractTuples(key, workingMemory);
        }
    }

    protected void propagateModifyTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        TupleSink sink = this.getTupleSink();
        if (sink != null) {
            sink.modifyTuples(trigger, newTuples, workingMemory);
        }
    }

    public TupleSink getTupleSink() {
        return this.tupleSink;
    }

    public abstract Set getTupleDeclarations();
}

