/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.reteoo.AgendaItem;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.Scheduler;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.rule.Rule;
import org.drools.spi.ConflictResolver;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Duration;

class Agenda {
    private WorkingMemory workingMemory;
    private ConflictResolver conflictResolver;
    private LinkedList items;
    private Set scheduledItems;

    public Agenda(WorkingMemory workingMemory, ConflictResolver conflictResolver) {
        this.workingMemory = workingMemory;
        this.conflictResolver = conflictResolver;
        this.items = new LinkedList();
        this.scheduledItems = new HashSet();
    }

    void addToAgenda(ReteTuple tuple, Rule rule) {
        if (rule == null) {
            return;
        }
        AgendaItem item = new AgendaItem(tuple, rule);
        Duration dur = rule.getDuration();
        if (dur != null && dur.getDuration(tuple) > 0L) {
            this.scheduledItems.add(item);
            this.scheduleItem(item);
        } else {
            this.conflictResolver.insert(item, this.items);
        }
    }

    void removeFromAgenda(TupleKey key, Rule rule) {
        if (rule == null) {
            return;
        }
        Iterator itemIter = this.items.iterator();
        AgendaItem eachItem = null;
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            itemIter.remove();
        }
        itemIter = this.scheduledItems.iterator();
        eachItem = null;
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.getKey().containsAll(key)) continue;
            this.cancelItem(eachItem);
            itemIter.remove();
        }
    }

    void modifyAgenda(FactHandle trigger, TupleSet newTuples, Rule rule) {
        Iterator itemIter = this.items.iterator();
        AgendaItem eachItem = null;
        ReteTuple eachTuple = null;
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.dependsOn(trigger) || !newTuples.containsTuple(eachItem.getKey())) continue;
            eachItem.setTuple(newTuples.getTuple(eachItem.getKey()));
            newTuples.removeTuple(eachItem.getKey());
        }
        itemIter = this.scheduledItems.iterator();
        eachItem = null;
        while (itemIter.hasNext()) {
            eachItem = (AgendaItem)itemIter.next();
            if (eachItem.getRule() != rule || !eachItem.dependsOn(trigger)) continue;
            if (!newTuples.containsTuple(eachItem.getKey())) {
                this.cancelItem(eachItem);
                itemIter.remove();
                continue;
            }
            eachItem.setTuple(newTuples.getTuple(eachItem.getKey()));
            newTuples.removeTuple(eachItem.getKey());
        }
        Iterator tupleIter = newTuples.iterator();
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            this.addToAgenda(eachTuple, rule);
        }
    }

    void scheduleItem(AgendaItem item) {
        Scheduler.getInstance().scheduleAgendaItem(item, this.workingMemory);
    }

    void cancelItem(AgendaItem item) {
        Scheduler.getInstance().cancelAgendaItem(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void fireNextItem() throws ConsequenceException {
        if (this.isEmpty()) {
            return;
        }
        AgendaItem item = (AgendaItem)this.items.removeFirst();
        item.fire(this.workingMemory);
    }
}

