/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;
import org.drools.spi.Extractor;

class ExtractionNode
extends TupleSource
implements TupleSink,
Serializable {
    private Set tupleDeclarations;
    private Declaration targetDeclaration;
    private Extractor extractor;

    public ExtractionNode(TupleSource tupleSource, Declaration targetDeclaration, Extractor extractor) {
        this.extractor = extractor;
        this.targetDeclaration = targetDeclaration;
        Set sourceDecls = tupleSource.getTupleDeclarations();
        this.tupleDeclarations = new HashSet(sourceDecls.size() + 1);
        this.tupleDeclarations.addAll(sourceDecls);
        this.tupleDeclarations.add(targetDeclaration);
        tupleSource.setTupleSink(this);
    }

    public Declaration getTargetDeclaration() {
        return this.targetDeclaration;
    }

    public Extractor getExtractor() {
        return this.extractor;
    }

    public Set getTupleDeclarations() {
        return this.tupleDeclarations;
    }

    public void assertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        Object value = this.getExtractor().extractFact(tuple);
        ReteTuple newTuple = new ReteTuple(tuple);
        newTuple.putColumn(this.getTargetDeclaration(), value);
        this.propagateAssertTuple(newTuple, workingMemory);
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        this.propagateRetractTuples(key, workingMemory);
    }

    public void modifyTuples(FactHandle trigger, TupleSet newTuples, WorkingMemoryImpl workingMemory) throws FactException {
        HashSet<TupleKey> retractedKeys = new HashSet<TupleKey>();
        Iterator tupleIter = newTuples.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            retractedKeys.add(eachTuple.getKey());
        }
        Iterator keyIter = retractedKeys.iterator();
        TupleKey eachKey = null;
        while (keyIter.hasNext()) {
            eachKey = (TupleKey)keyIter.next();
            this.propagateRetractTuples(eachKey, workingMemory);
        }
        tupleIter = newTuples.iterator();
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            this.assertTuple(eachTuple, workingMemory);
        }
    }

    public String toString() {
        return "[ExtractionNodeImpl: target=" + this.getTargetDeclaration() + "; extractor=" + this.getExtractor() + "]";
    }
}

