/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.JoinTuple;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;

class JoinMemory {
    private TupleSet leftTuples = new TupleSet();
    private TupleSet rightTuples = new TupleSet();
    private Set joinDeclarations;

    JoinMemory(JoinNode node) {
        this.joinDeclarations = node.getCommonDeclarations();
    }

    protected void retractObject(FactHandle handle) {
        try {
            ReteTuple eachTuple = null;
            Iterator tupleIter = this.leftTuples.iterator();
            while (tupleIter.hasNext()) {
                eachTuple = (ReteTuple)tupleIter.next();
                if (!eachTuple.dependsOn(handle)) continue;
                tupleIter.remove();
            }
            tupleIter = this.rightTuples.iterator();
            while (tupleIter.hasNext()) {
                eachTuple = (ReteTuple)tupleIter.next();
                if (!eachTuple.dependsOn(handle)) continue;
                tupleIter.remove();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void retractTuples(Set keys) {
        Iterator keyIter = keys.iterator();
        TupleKey eachKey = null;
        while (keyIter.hasNext()) {
            eachKey = (TupleKey)keyIter.next();
            this.retractTuples(eachKey);
        }
    }

    protected void retractTuples(TupleKey key) {
        this.retractTuples(key, this.getLeftTuples().iterator());
        this.retractTuples(key, this.getRightTuples().iterator());
    }

    private void retractTuples(TupleKey key, Iterator tupleIter) {
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            if (!eachTuple.getKey().containsAll(key)) continue;
            tupleIter.remove();
        }
    }

    protected void modifyLeftTuples(FactHandle trigger, TupleSet newTuples, JoinNode joinNode, WorkingMemoryImpl workingMemory) throws FactException {
        this.modifyTuples(trigger, newTuples, this.getLeftTuples(), this.getRightTuples(), joinNode, workingMemory);
    }

    protected void modifyRightTuples(FactHandle trigger, TupleSet newTuples, JoinNode joinNode, WorkingMemoryImpl workingMemory) throws FactException {
        this.modifyTuples(trigger, newTuples, this.getRightTuples(), this.getLeftTuples(), joinNode, workingMemory);
    }

    protected void modifyTuples(FactHandle trigger, TupleSet newTuples, TupleSet thisSideTuples, TupleSet thatSideTuples, JoinNode joinNode, WorkingMemoryImpl workingMemory) throws FactException {
        HashSet<ReteTuple> origModified = new HashSet<ReteTuple>();
        HashSet<ReteTuple> newModified = new HashSet<ReteTuple>();
        Iterator tupleIter = thisSideTuples.iterator();
        while (tupleIter.hasNext()) {
            ReteTuple origTuple = (ReteTuple)tupleIter.next();
            if (!origTuple.dependsOn(trigger)) continue;
            ReteTuple newTuple = newTuples.getTuple(origTuple.getKey());
            if (newTuple == null) {
                tupleIter.remove();
                continue;
            }
            newModified.add(newTuple);
            origModified.add(origTuple);
        }
        newModified.addAll(newTuples.getTuples());
        TupleSet origJoined = new TupleSet();
        Iterator tupleIter2 = origModified.iterator();
        while (tupleIter2.hasNext()) {
            ReteTuple eachTuple = (ReteTuple)tupleIter2.next();
            origJoined.addAllTuples(this.attemptJoin(eachTuple, thatSideTuples.iterator()));
        }
        TupleSet newJoined = new TupleSet();
        Iterator tupleIter3 = newModified.iterator();
        while (tupleIter3.hasNext()) {
            ReteTuple eachTuple = (ReteTuple)tupleIter3.next();
            newJoined.addAllTuples(this.attemptJoin(eachTuple, thatSideTuples.iterator()));
        }
        thisSideTuples.addAllTuples(newTuples);
        joinNode.propagateModifyTuples(trigger, newJoined, workingMemory);
    }

    private void propagateRetractTuples(Object trigger, Set retractedKeys, JoinNode joinNode, WorkingMemoryImpl workingMemory) throws FactException {
        Iterator keyIter = retractedKeys.iterator();
        TupleKey eachKey = null;
        while (keyIter.hasNext()) {
            eachKey = (TupleKey)keyIter.next();
            joinNode.propagateRetractTuples(eachKey, workingMemory);
        }
    }

    protected Set addLeftTuple(JoinNode node, ReteTuple tuple) {
        this.leftTuples.addTuple(tuple);
        Set joined = this.attemptJoin(tuple, this.getRightTupleIterator());
        return joined;
    }

    protected TupleSet getLeftTuples() {
        return this.leftTuples;
    }

    protected Iterator getLeftTupleIterator() {
        return this.leftTuples.iterator();
    }

    protected Set addRightTuple(JoinNode node, ReteTuple tuple) {
        this.rightTuples.addTuple(tuple);
        return this.attemptJoin(tuple, this.getLeftTupleIterator());
    }

    protected TupleSet getRightTuples() {
        return this.rightTuples;
    }

    protected Iterator getRightTupleIterator() {
        return this.rightTuples.iterator();
    }

    protected Iterator getJoinDeclarationIterator() {
        return this.joinDeclarations.iterator();
    }

    protected Set attemptJoin(ReteTuple tuple, Iterator tupleIter) {
        HashSet<ReteTuple> joinedTuples = Collections.EMPTY_SET;
        ReteTuple eachTuple = null;
        ReteTuple joinedTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            joinedTuple = this.attemptJoin(tuple, eachTuple);
            if (joinedTuple == null) continue;
            if (joinedTuples == Collections.EMPTY_SET) {
                joinedTuples = new HashSet<ReteTuple>();
            }
            joinedTuples.add(joinedTuple);
        }
        return joinedTuples;
    }

    protected ReteTuple attemptJoin(ReteTuple left, ReteTuple right) {
        Iterator declIter = this.getJoinDeclarationIterator();
        Declaration eachDecl = null;
        FactHandle leftHandle = null;
        FactHandle rightHandle = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            leftHandle = left.getKey().get(eachDecl);
            rightHandle = right.getKey().get(eachDecl);
            if (leftHandle == null && rightHandle == null) continue;
            if (leftHandle == null || rightHandle == null) {
                return null;
            }
            if (leftHandle.equals(rightHandle)) continue;
            return null;
        }
        JoinTuple joinedTuple = new JoinTuple(left, right);
        return joinedTuple;
    }

    public String toString() {
        return "[JoinMemory \n\tleft=" + this.leftTuples + "\n\tright=" + this.rightTuples + "]";
    }
}

