/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.reteoo.TupleKey;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.spi.Tuple;

class ReteTuple
implements Tuple {
    private WorkingMemory workingMemory;
    private Rule rule;
    private TupleKey key;
    private Map columns;
    private Map objectToHandle;

    public ReteTuple(WorkingMemory workingMemory, Rule rule) {
        this.workingMemory = workingMemory;
        this.rule = rule;
        this.key = new TupleKey();
        this.columns = new HashMap();
        this.objectToHandle = new HashMap();
    }

    ReteTuple(ReteTuple that) {
        this.workingMemory = that.workingMemory;
        this.rule = that.rule;
        this.key = new TupleKey(that.key);
        this.columns = new HashMap(that.columns);
        this.objectToHandle = new HashMap(that.objectToHandle);
    }

    ReteTuple(WorkingMemory workingMemory, Rule rule, Declaration declaration, FactHandle handle, Object value) {
        this(workingMemory, rule);
        this.putKeyColumn(declaration, handle, value);
    }

    public String toString() {
        return "[Tuple: key=" + this.key + "; columns=" + this.columns + "; o2h=" + this.objectToHandle + "]";
    }

    public void putKeyColumn(Declaration declaration, FactHandle handle, Object value) {
        this.key.put(declaration, handle);
        this.objectToHandle.put(value, handle);
        this.putColumn(declaration, value);
    }

    public void putAll(ReteTuple that) {
        this.key.putAll(that.key);
        this.columns.putAll(that.columns);
        this.objectToHandle.putAll(that.objectToHandle);
    }

    public void putColumn(Declaration declaration, Object value) {
        this.columns.put(declaration, value);
    }

    TupleKey getKey() {
        return this.key;
    }

    Map getOtherColumns() {
        return this.columns;
    }

    boolean dependsOn(FactHandle handle) {
        return this.key.containsRootFactHandle(handle);
    }

    public Object get(Declaration declaration) {
        return this.columns.get(declaration);
    }

    public Set getDeclarations() {
        return this.columns.keySet();
    }

    public FactHandle getFactHandleForObject(Object object) {
        return (FactHandle)this.objectToHandle.get(object);
    }

    public Rule getRule() {
        return this.rule;
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }
}

