/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.drools.FactHandle;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;

class TupleSet {
    private Map tuples;

    TupleSet() {
        this.tuples = new HashMap();
    }

    TupleSet(ReteTuple tuple) {
        this(1);
        this.addTuple(tuple);
    }

    TupleSet(Set tuples) {
        this.tuples = new HashMap(tuples.size());
        this.addAllTuples(tuples);
    }

    TupleSet(int sizeHint) {
        this.tuples = new HashMap(sizeHint);
    }

    public int size() {
        return this.tuples.size();
    }

    public void addAllTuples(Set tuples) {
        Iterator tupleIter = tuples.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            this.addTuple(eachTuple);
        }
    }

    public void addAllTuples(TupleSet tupleSet) {
        this.tuples.putAll(tupleSet.tuples);
    }

    public void addTuple(ReteTuple tuple) {
        this.tuples.put(tuple.getKey(), tuple);
    }

    public void removeTuple(TupleKey key) {
        this.tuples.remove(key);
    }

    public void removeTuplesByPartialKey(TupleKey key) {
        Iterator tupleIter = this.iterator();
        ReteTuple eachTuple = null;
        while (tupleIter.hasNext()) {
            eachTuple = (ReteTuple)tupleIter.next();
            if (!eachTuple.getKey().containsAll(key)) continue;
            tupleIter.remove();
        }
    }

    public Set getTuples() {
        return new HashSet(this.tuples.values());
    }

    public Iterator iterator() {
        return new Itr(this.tuples);
    }

    public Set getTuples(FactHandle handle) {
        HashSet<ReteTuple> matchingTuples = new HashSet<ReteTuple>();
        Iterator keyIter = this.getKeys().iterator();
        TupleKey eachKey = null;
        while (keyIter.hasNext()) {
            eachKey = (TupleKey)keyIter.next();
            if (!eachKey.containsRootFactHandle(handle)) continue;
            matchingTuples.add(this.getTuple(eachKey));
        }
        return matchingTuples;
    }

    public Set getKeys() {
        return this.tuples.keySet();
    }

    public ReteTuple getTuple(TupleKey key) {
        return (ReteTuple)this.tuples.get(key);
    }

    public boolean containsTuple(TupleKey key) {
        return this.tuples.containsKey(key);
    }

    public String toString() {
        return this.tuples.values().toString();
    }

    static class Itr
    implements Iterator {
        private Map tuples;
        private Iterator keyIter;

        Itr(Map tuples) {
            this.tuples = tuples;
            this.keyIter = tuples.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keyIter.hasNext();
        }

        public Object next() {
            return this.tuples.get(this.keyIter.next());
        }

        public void remove() {
            this.keyIter.remove();
        }
    }
}

