/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.drools.rule.Declaration;
import org.drools.rule.Extraction;
import org.drools.rule.FixedDuration;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.NoConditionException;
import org.drools.rule.NoConsequenceException;
import org.drools.rule.NoParameterDeclarationException;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Duration;

public class Rule {
    public static final Rule[] EMPTY_ARRAY = new Rule[0];
    private String name;
    private String documentation;
    private int salience;
    private Set allDeclarations;
    private Set parameterDeclarations;
    private List conditions;
    private Set extractions;
    private Consequence consequence;
    private Duration duration;

    public Rule(String name) {
        this.name = name;
        this.parameterDeclarations = Collections.EMPTY_SET;
        this.allDeclarations = Collections.EMPTY_SET;
        this.conditions = Collections.EMPTY_LIST;
        this.extractions = Collections.EMPTY_SET;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDuration(long seconds) {
        this.duration = new FixedDuration(seconds);
    }

    public void setDuration(Duration duration) {
        this.duration = duration;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public boolean isValid() {
        return this.getParameterDeclarations().length != 0 && this.getConditions().length != 0 && this.getExtractions().length != 0 && this.getConsequence() != null;
    }

    public void checkValidity() throws InvalidRuleException {
        if (this.getParameterDeclarations().length == 0) {
            throw new NoParameterDeclarationException(this);
        }
        if (this.getConditions().length == 0) {
            throw new NoConditionException(this);
        }
        if (this.getConsequence() == null) {
            throw new NoConsequenceException(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getSalience() {
        return this.salience;
    }

    public void setSalience(int salience) {
        this.salience = salience;
    }

    public void addParameterDeclaration(Declaration declaration) {
        if (this.parameterDeclarations == Collections.EMPTY_SET) {
            this.parameterDeclarations = new HashSet();
        }
        this.parameterDeclarations.add(declaration);
        this.addDeclaration(declaration);
    }

    public void addDeclaration(Declaration declaration) {
        if (this.allDeclarations == Collections.EMPTY_SET) {
            this.allDeclarations = new HashSet();
        }
        this.allDeclarations.add(declaration);
    }

    public Declaration getParameterDeclaration(String identifier) {
        Iterator declIter = this.parameterDeclarations.iterator();
        Declaration eachDecl = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            if (!eachDecl.getIdentifier().equals(identifier)) continue;
            return eachDecl;
        }
        return null;
    }

    public Declaration getDeclaration(String identifier) {
        Iterator declIter = this.allDeclarations.iterator();
        Declaration eachDecl = null;
        while (declIter.hasNext()) {
            eachDecl = (Declaration)declIter.next();
            if (!eachDecl.getIdentifier().equals(identifier)) continue;
            return eachDecl;
        }
        return null;
    }

    public Declaration[] getParameterDeclarations() {
        return this.parameterDeclarations.toArray(Declaration.EMPTY_ARRAY);
    }

    public Declaration[] getLocalDeclarations() {
        HashSet localDecls = new HashSet(this.allDeclarations);
        localDecls.removeAll(this.parameterDeclarations);
        return localDecls.toArray(Declaration.EMPTY_ARRAY);
    }

    public Declaration[] getAllDeclarations() {
        return this.allDeclarations.toArray(Declaration.EMPTY_ARRAY);
    }

    public void addCondition(Condition condition) {
        if (this.conditions == Collections.EMPTY_LIST) {
            this.conditions = new ArrayList();
        }
        this.conditions.add(condition);
    }

    public void addExtraction(Extraction extraction) {
        if (this.extractions == Collections.EMPTY_SET) {
            this.extractions = new HashSet();
        }
        this.extractions.add(extraction);
        Declaration decl = extraction.getTargetDeclaration();
        this.addDeclaration(decl);
    }

    public Condition[] getConditions() {
        return this.conditions.toArray(Condition.EMPTY_ARRAY);
    }

    public Extraction[] getExtractions() {
        return this.extractions.toArray(Extraction.EMPTY_ARRAY);
    }

    public void setConsequence(Consequence consequence) {
        this.consequence = consequence;
    }

    public Consequence getConsequence() {
        return this.consequence;
    }
}

