/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.drools.rule.DuplicateRuleNameException;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;

public class RuleSet {
    public static final RuleSet[] EMPTY_ARRAY = new RuleSet[0];
    private String name;
    private String documentation;
    private Set ruleNames;
    private List rules;

    public RuleSet(String name) {
        this.name = name;
        this.ruleNames = new HashSet();
        this.rules = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addRule(Rule rule) throws DuplicateRuleNameException, InvalidRuleException {
        rule.checkValidity();
        String name = rule.getName();
        if (this.containsRule(name)) {
            throw new DuplicateRuleNameException(this, this.getRule(name), rule);
        }
        this.ruleNames.add(name);
        this.rules.add(rule);
    }

    public Rule getRule(String name) {
        Rule[] rules = this.getRules();
        int i = 0;
        while (i < rules.length) {
            if (rules[i].getName().equals(name)) {
                return rules[i];
            }
            ++i;
        }
        return null;
    }

    public boolean containsRule(String name) {
        return this.ruleNames.contains(name);
    }

    public Rule[] getRules() {
        return this.rules.toArray(Rule.EMPTY_ARRAY);
    }
}

