/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Iterator;
import java.util.Set;
import org.drools.AssertionException;
import org.drools.FactException;
import org.drools.FactHandle;
import org.drools.RetractionException;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.TupleSet;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Rule;
import org.drools.spi.Condition;

class ConditionNode
extends TupleSource
implements TupleSink {
    private final Rule rule;
    private final Condition condition;
    private final TupleSource tupleSource;

    ConditionNode(Rule rule, TupleSource tupleSource, Condition condition) {
        this.rule = rule;
        this.condition = condition;
        this.tupleSource = tupleSource;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public Set getTupleDeclarations() {
        return this.tupleSource.getTupleDeclarations();
    }

    public void assertTuple(ReteTuple tuple, WorkingMemoryImpl workingMemory) throws AssertionException {
        boolean allowed = this.condition.isAllowed(tuple);
        workingMemory.getEventSupport().fireConditionTested(this.rule, this.condition, tuple, allowed);
        if (allowed) {
            this.propagateAssertTuple(tuple, workingMemory);
        }
    }

    public void retractTuples(TupleKey key, WorkingMemoryImpl workingMemory) throws RetractionException {
        this.propagateRetractTuples(key, workingMemory);
    }

    public void modifyTuples(FactHandle trigger, TupleSet modifyTuples, WorkingMemoryImpl workingMemory) throws FactException {
        TupleSet allowedTuples = new TupleSet();
        Iterator tupleIter = modifyTuples.iterator();
        while (tupleIter.hasNext()) {
            ReteTuple eachTuple = (ReteTuple)tupleIter.next();
            boolean allowed = this.condition.isAllowed(eachTuple);
            workingMemory.getEventSupport().fireConditionTested(this.rule, this.condition, eachTuple, allowed);
            if (allowed) {
                allowedTuples.addTuple(eachTuple);
                continue;
            }
            this.propagateRetractTuples(eachTuple.getKey(), workingMemory);
        }
        if (!allowedTuples.isEmpty()) {
            this.propagateModifyTuples(trigger, allowedTuples, workingMemory);
        }
    }

    public String toString() {
        return "[ConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConditionNode other = (ConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }
}

