/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Serializable;
import org.drools.FactHandle;
import org.drools.NoSuchFactHandleException;
import org.drools.NoSuchFactObjectException;
import org.drools.WorkingMemory;
import org.drools.reteoo.FactHandleImpl;
import org.drools.reteoo.TupleKey;
import org.drools.reteoo.WorkingMemoryImpl;
import org.drools.rule.Declaration;
import org.drools.spi.Tuple;

class ReteTuple
implements Tuple,
Serializable {
    private final WorkingMemoryImpl workingMemory;
    private final TupleKey key;
    private FactHandleImpl mostRecentFact;
    private FactHandleImpl leastRecentFact;

    ReteTuple(WorkingMemoryImpl workingMemory) {
        this.workingMemory = workingMemory;
        this.key = TupleKey.EMPTY_KEY;
    }

    ReteTuple(ReteTuple left, ReteTuple right) {
        this.workingMemory = left.workingMemory;
        this.key = new TupleKey(left.key, right.key);
    }

    ReteTuple(WorkingMemoryImpl workingMemory, Declaration declaration, FactHandle handle) {
        this.workingMemory = workingMemory;
        this.key = new TupleKey(declaration, handle);
    }

    public String toString() {
        return "{" + this.key.getDeclarations() + "}";
    }

    TupleKey getKey() {
        return this.key;
    }

    boolean dependsOn(FactHandle handle) {
        return this.key.containsFactHandle(handle);
    }

    public Object get(Declaration declaration) {
        FactHandle handle = this.key.get(declaration);
        if (handle != null) {
            try {
                return this.workingMemory.getObject(handle);
            }
            catch (NoSuchFactObjectException noSuchFactObjectException) {
                // empty catch block
            }
        }
        return null;
    }

    public FactHandle getFactHandleForObject(Object object) {
        try {
            return this.workingMemory.getFactHandle(object);
        }
        catch (NoSuchFactHandleException e) {
            return null;
        }
    }

    public WorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public long getMostRecentFactTimeStamp() {
        if (this.mostRecentFact == null) {
            this.mostRecentFact = this.key.getMostRecentFact();
        }
        return this.mostRecentFact.getRecency();
    }

    public long getLeastRecentFactTimeStamp() {
        if (this.leastRecentFact == null) {
            this.leastRecentFact = this.key.getLeastRecentFact();
        }
        return this.leastRecentFact.getRecency();
    }
}

