/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser.xls;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.drools.decisiontable.parser.DecisionTableParseException;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.SheetListener;
import org.drools.decisiontable.parser.xls.NullSheetListener;

public class ExcelParser
implements DecisionTableParser {
    public static final String DEFAULT_RULESHEET_NAME = "Decision Tables";
    private Map _listners = new HashMap();
    private SheetListener _currentSheetListener = new NullSheetListener();
    private boolean _useFirstSheet;

    public ExcelParser(Map map) {
        this._listners = map;
    }

    public ExcelParser(SheetListener sheetListener) {
        this._listners.put(DEFAULT_RULESHEET_NAME, sheetListener);
        this._useFirstSheet = true;
        this._currentSheetListener = sheetListener;
    }

    public void parseFile(InputStream inputStream) {
        try {
            Workbook workbook = Workbook.getWorkbook((InputStream)inputStream);
            if (this._useFirstSheet) {
                Sheet sheet = workbook.getSheet(0);
                this.processSheet(sheet, this._currentSheetListener);
            } else {
                Set set = this._listners.keySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Sheet sheet = workbook.getSheet(string);
                    this.processSheet(sheet, (SheetListener)this._listners.get(string));
                }
            }
        }
        catch (BiffException biffException) {
            throw new DecisionTableParseException("An error occured opening the workbook. ", biffException);
        }
        catch (IOException iOException) {
            throw new DecisionTableParseException("Failed to open Excel stream, please check that the content is xls97 format.", iOException);
        }
    }

    private void processSheet(Sheet sheet, SheetListener sheetListener) {
        int n = sheet.getRows();
        Range[] rangeArray = sheet.getMergedCells();
        for (int i = 0; i < n; ++i) {
            Cell[] cellArray = sheet.getRow(i);
            sheetListener.newRow(i, cellArray.length);
            for (int j = 0; j < cellArray.length; ++j) {
                Cell cell = cellArray[j];
                Range range = this.getRangeIfMerged(cell, rangeArray);
                if (range != null) {
                    Cell cell2 = range.getTopLeft();
                    sheetListener.newCell(i, j, cell2.getContents(), cell2.getColumn());
                    continue;
                }
                sheetListener.newCell(i, j, cell.getContents(), -1);
            }
        }
        sheetListener.finishSheet();
    }

    Range getRangeIfMerged(Cell cell, Range[] rangeArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            Range range = rangeArray[i];
            Cell cell2 = range.getTopLeft();
            Cell cell3 = range.getBottomRight();
            if (cell.getRow() < cell2.getRow() || cell.getRow() > cell3.getRow() || cell.getColumn() < cell2.getColumn() || cell.getColumn() > cell3.getColumn()) continue;
            return range;
        }
        return null;
    }

    static String removeTrailingZero(String string) {
        if (string.endsWith(".0")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }
}

