/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.MockTuple;
import org.drools.MockWorkingMemory;
import org.drools.rule.Declaration;
import org.drools.smf.ConditionFactory;
import org.drools.smf.Configuration;
import org.drools.smf.ConsequenceFactory;
import org.drools.smf.DefaultSemanticsRepository;
import org.drools.smf.ExtractorFactory;
import org.drools.smf.MockConfiguration;
import org.drools.smf.ObjectTypeFactory;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsRepository;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.Extractor;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public abstract class SMFTestFrameWork
extends TestCase {
    private String semantic;
    private List tests;
    private String testType;
    private SemanticModule module;
    private SemanticsRepository repository;
    private String newline = System.getProperty("line.separator");
    static /* synthetic */ Class class$org$drools$smf$SMFTestFrameWork$Cheese;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public SMFTestFrameWork(String name) {
        super(name);
        this.testType = name.substring(4).toLowerCase();
    }

    public void setUp(String semantic) throws Exception {
        this.semantic = semantic;
        if (!(this.testType.equals("conditions") || this.testType.equals("extractors") || this.testType.equals("consequences"))) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL semanticTests = cl.getResource(semantic + "-" + this.testType + ".data");
        BufferedReader in = new BufferedReader(new InputStreamReader(semanticTests.openStream()));
        StringBuffer buffer = new StringBuffer();
        String blockMarker = "<!--drools-test--!>";
        this.tests = new ArrayList();
        while (in.ready()) {
            String line = in.readLine() + this.newline;
            if (line.startsWith(blockMarker)) {
                this.tests.add(buffer.toString());
                buffer = new StringBuffer();
                continue;
            }
            buffer.append(line);
        }
        this.tests.add(buffer.toString());
        this.repository = DefaultSemanticsRepository.getInstance();
        this.module = this.repository.lookupSemanticModule("http://drools.org/semantics/" + semantic);
    }

    public void testConditions() throws Exception {
        int testNumber = 0;
        MockConfiguration cheeseConfiguration = new MockConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        ObjectType cheeseType = objectTypeFactory.newObjectType((Configuration)cheeseConfiguration);
        MockTuple tuple = new MockTuple();
        tuple.setWorkingMemory(new MockWorkingMemory());
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
        Declaration camembertDecl = new Declaration(cheeseType, "camembert");
        Declaration stiltonDecl = new Declaration(cheeseType, "stilton");
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{camembertDecl}));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{camembertDecl}));
        tuple = new MockTuple();
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl}));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl}));
        tuple = new MockTuple();
        tuple.setWorkingMemory(new MockWorkingMemory());
        tuple.put(stiltonDecl, new Cheese("stilton"));
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("favouriteCheese", new Cheese("camembert"));
        tuple.setWorkingMemory(workingMemory);
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        Assert.assertFalse((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{stiltonDecl, camembertDecl}));
        tuple = new MockTuple();
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        MockConfiguration stringConfiguration = new MockConfiguration("test2");
        stringConfiguration.setText((class$java$lang$String == null ? (class$java$lang$String = SMFTestFrameWork.class$("java.lang.String")) : class$java$lang$String).getName());
        ObjectType stringType = objectTypeFactory.newObjectType((Configuration)stringConfiguration);
        Declaration favouriteCheeseDecl = new Declaration(stringType, "favouriteCheese");
        tuple.put(favouriteCheeseDecl, "camembert");
        tuple.put(camembertDecl, new Cheese("camembert"));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{favouriteCheeseDecl, camembertDecl}));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[]{camembertDecl, favouriteCheeseDecl}));
        Assert.assertTrue((boolean)this.testCondition(testNumber++, tuple, new Declaration[0]));
    }

    private boolean testCondition(int testNumber, Tuple tuple, Declaration[] decls) throws Exception {
        ConditionFactory conditionFactory = this.module.getConditionFactory("condition");
        MockConfiguration conditionConfiguration = new MockConfiguration("test" + testNumber);
        conditionConfiguration.setText((String)this.tests.get(testNumber));
        Condition condition = conditionFactory.newCondition((Configuration)conditionConfiguration, decls);
        return condition.isAllowed(tuple);
    }

    public void testExtractors() throws Exception {
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        MockConfiguration cheeseConfiguration = new MockConfiguration("cheeseConfig");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectType cheeseType = objectTypeFactory.newObjectType((Configuration)cheeseConfiguration);
        MockConfiguration integerConfiguration = new MockConfiguration("integerConfig");
        integerConfiguration.setText((class$java$lang$Integer == null ? (class$java$lang$Integer = SMFTestFrameWork.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        ObjectType integerType = objectTypeFactory.newObjectType((Configuration)integerConfiguration);
        Declaration camembertDecl = new Declaration(cheeseType, "camembert");
        Declaration stiltonDecl = new Declaration(cheeseType, "stilton");
        Declaration integerDecl = new Declaration(integerType, "bitesLeft");
        int testNumber = 0;
        MockTuple tuple = new MockTuple();
        tuple.setWorkingMemory(new MockWorkingMemory());
        Assert.assertEquals((String)"camembert", (String)((String)this.testExtractor(testNumber++, "java.lang.String", tuple, new Declaration[0])));
        Cheese camembert = new Cheese("camembert");
        tuple.put(camembertDecl, camembert);
        Assert.assertEquals((String)"I have 3 bites of camembert left", (String)((String)this.testExtractor(testNumber++, "java.lang.String", tuple, new Declaration[]{camembertDecl})));
        Cheese stilton = new Cheese("stilton");
        tuple.put(stiltonDecl, stilton);
        Assert.assertEquals((String)"I have 3 bites of stilton left", (String)((String)this.testExtractor(testNumber++, "java.lang.String", tuple, new Declaration[]{camembertDecl, stiltonDecl})));
        tuple.put(integerDecl, new Integer(camembert.getBitesLeft()));
        Assert.assertEquals((Object)new Integer(3), (Object)this.testExtractor(testNumber++, "java.lang.Integer", tuple, new Declaration[]{camembertDecl, stiltonDecl, integerDecl}));
        tuple.put(integerDecl, new Integer(stilton.getBitesLeft()));
        Assert.assertEquals((Object)new Integer(6), (Object)this.testExtractor(testNumber++, "java.lang.Integer", tuple, new Declaration[]{camembertDecl, stiltonDecl, integerDecl}));
        Assert.assertEquals((Object)new Cheese("cheddar"), (Object)this.testExtractor(testNumber++, "org.drools.smf.SMFTestFrameWork$Cheese", tuple, new Declaration[]{camembertDecl, stiltonDecl}));
        camembert.eatCheese();
        Assert.assertEquals((Object)new Cheese("mozzerella"), (Object)this.testExtractor(testNumber++, "org.drools.smf.SMFTestFrameWork$Cheese", tuple, new Declaration[]{camembertDecl, stiltonDecl}));
    }

    private Object testExtractor(int testNumber, String returnType, Tuple tuple, Declaration[] decls) throws Exception {
        ExtractorFactory extractorFactory = this.module.getExtractorFactory("extractor");
        MockConfiguration extractorConfiguration = new MockConfiguration("test" + testNumber);
        extractorConfiguration.setAttribute("javaClass", returnType);
        extractorConfiguration.setText((String)this.tests.get(testNumber));
        Extractor extractor = extractorFactory.newExtractor((Configuration)extractorConfiguration, decls);
        Object fact = extractor.extractFact(tuple);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (!cl.loadClass(returnType).isInstance(fact)) {
            Assert.fail((String)"Incorrect return type for Extractor");
        }
        return fact;
    }

    public void testConsequences() throws Exception {
        MockConfiguration cheeseConfiguration = new MockConfiguration("test1");
        cheeseConfiguration.setText((class$org$drools$smf$SMFTestFrameWork$Cheese == null ? (class$org$drools$smf$SMFTestFrameWork$Cheese = SMFTestFrameWork.class$("org.drools.smf.SMFTestFrameWork$Cheese")) : class$org$drools$smf$SMFTestFrameWork$Cheese).getName());
        ObjectTypeFactory objectTypeFactory = this.module.getObjectTypeFactory("class");
        ObjectType cheeseType = objectTypeFactory.newObjectType((Configuration)cheeseConfiguration);
        MockTuple tuple = new MockTuple();
        tuple.setWorkingMemory(new MockWorkingMemory());
        this.testConsequence(0, tuple, new Declaration[0]);
        Declaration camembertDecl = new Declaration(cheeseType, "camembert");
        Declaration stiltonDecl = new Declaration(cheeseType, "stilton");
        Cheese camembert = new Cheese("camembert");
        Cheese stilton = new Cheese("stilton");
        tuple.put(camembertDecl, camembert);
        tuple.put(stiltonDecl, stilton);
        this.testConsequence(1, tuple, new Declaration[0]);
        Assert.assertEquals((int)3, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)3, (int)stilton.getBitesLeft());
        this.testConsequence(2, tuple, new Declaration[]{stiltonDecl, camembertDecl});
        Assert.assertEquals((int)2, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)1, (int)stilton.getBitesLeft());
        MockWorkingMemory workingMemory = new MockWorkingMemory();
        workingMemory.setApplicationData("bites", new Integer(3));
        workingMemory.setApplicationData("cheeses", new HashMap());
        tuple.setWorkingMemory(workingMemory);
        this.testConsequence(3, tuple, new Declaration[]{stiltonDecl, camembertDecl});
        Assert.assertEquals((int)1, (int)camembert.getBitesLeft());
        Assert.assertEquals((int)0, (int)stilton.getBitesLeft());
        Map map = (Map)workingMemory.getApplicationData("cheeses");
        Assert.assertEquals((Object)camembert, map.get("favourite cheese"));
        Assert.assertEquals((int)3, (int)((Integer)map.get("bites")));
        tuple = new MockTuple();
        workingMemory = new MockWorkingMemory();
        tuple.setWorkingMemory(workingMemory);
        MockConfiguration stringConfiguration = new MockConfiguration("test2");
        stringConfiguration.setText((class$java$lang$String == null ? (class$java$lang$String = SMFTestFrameWork.class$("java.lang.String")) : class$java$lang$String).getName());
        ObjectType stringType = objectTypeFactory.newObjectType((Configuration)stringConfiguration);
        Declaration favouriteCheeseDecl = new Declaration(stringType, "favouriteCheese");
        tuple.put(favouriteCheeseDecl, "camembert");
        tuple.put(camembertDecl, new Cheese("camembert"));
        this.testConsequence(4, tuple, new Declaration[]{favouriteCheeseDecl, camembertDecl});
        this.testConsequence(5, tuple, new Declaration[]{camembertDecl, favouriteCheeseDecl});
    }

    private void testConsequence(int testNumber, Tuple tuple, Declaration[] decls) throws Exception {
        ConsequenceFactory consequenceFactory = this.module.getConsequenceFactory("consequence");
        MockConfiguration consequenceConfiguration = new MockConfiguration("test" + testNumber);
        consequenceConfiguration.setText((String)this.tests.get(testNumber));
        Consequence consequence = consequenceFactory.newConsequence((Configuration)consequenceConfiguration, decls);
        consequence.invoke(tuple, tuple.getWorkingMemory());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Cheese {
        private String name;
        private int bitesLeft = 3;

        public Cheese(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void eatCheese() {
            --this.bitesLeft;
        }

        public int getBitesLeft() {
            return this.bitesLeft;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Cheese)) {
                return false;
            }
            Cheese otherCheese = (Cheese)object;
            return this.name.equals(otherCheese.getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

