/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.boot;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.internal.boot.InternalBootLoader;

public final class BootLoader {
    public static final String PI_BOOT = "org.eclipse.core.boot";
    public static final String OS_WIN32 = "win32";
    public static final String OS_LINUX = "linux";
    public static final String OS_AIX = "aix";
    public static final String OS_SOLARIS = "solaris";
    public static final String OS_HPUX = "hpux";
    public static final String OS_QNX = "qnx";
    public static final String OS_MACOSX = "macosx";
    public static final String OS_UNKNOWN = "unknown";
    public static final String ARCH_X86 = "x86";
    public static final String ARCH_PA_RISC = "PA_RISC";
    public static final String ARCH_PPC = "ppc";
    public static final String ARCH_SPARC = "sparc";
    public static final String WS_WIN32 = "win32";
    public static final String WS_MOTIF = "motif";
    public static final String WS_GTK = "gtk";
    public static final String WS_PHOTON = "photon";
    public static final String WS_CARBON = "carbon";
    public static final String WS_UNKNOWN = "unknown";
    private static final String[] ARCH_LIST = new String[]{"PA_RISC", "ppc", "sparc", "x86"};
    private static final String[] OS_LIST = new String[]{"aix", "hpux", "linux", "macosx", "qnx", "solaris", "win32"};
    private static final String[] WS_LIST = new String[]{"carbon", "gtk", "motif", "photon", "win32"};

    private BootLoader() {
    }

    public static boolean containsSavedPlatform(String location) {
        return InternalBootLoader.containsSavedPlatform(location);
    }

    public static String[] getCommandLineArgs() {
        return InternalBootLoader.getCommandLineArgs();
    }

    public static IPlatformConfiguration getCurrentPlatformConfiguration() {
        return InternalBootLoader.getCurrentPlatformConfiguration();
    }

    public static URL getInstallURL() {
        return InternalBootLoader.getInstallURL();
    }

    public static String getNL() {
        return InternalBootLoader.getNL();
    }

    public static String getOS() {
        return InternalBootLoader.getOS();
    }

    public static String getOSArch() {
        return InternalBootLoader.getOSArch();
    }

    public static IPlatformConfiguration getPlatformConfiguration(URL url) throws IOException {
        return InternalBootLoader.getPlatformConfiguration(url);
    }

    public static URL[] getPluginPath(URL pluginPathLocation) {
        return InternalBootLoader.getPluginPath(pluginPathLocation);
    }

    public static IPlatformRunnable getRunnable(String applicationName) throws Exception {
        return InternalBootLoader.getRunnable(applicationName);
    }

    public static IPlatformRunnable getRunnable(String pluginId, String className, Object args) throws Exception {
        return InternalBootLoader.getRunnable(pluginId, className, args);
    }

    public static String getWS() {
        return InternalBootLoader.getWS();
    }

    public static String[] knownOSArchValues() {
        return ARCH_LIST;
    }

    public static String[] knownOSValues() {
        return OS_LIST;
    }

    public static String[] knownWSValues() {
        return WS_LIST;
    }

    public static boolean inDebugMode() {
        return InternalBootLoader.inDebugMode();
    }

    public static boolean inDevelopmentMode() {
        return InternalBootLoader.inDevelopmentMode();
    }

    public static boolean isRunning() {
        return InternalBootLoader.isRunning();
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args) throws Exception {
        return InternalBootLoader.run(applicationName, pluginPathLocation, location, args, null);
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        return InternalBootLoader.run(applicationName, pluginPathLocation, location, args, handler);
    }

    public static void shutdown() throws Exception {
        InternalBootLoader.shutdown();
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args) throws Exception {
        return InternalBootLoader.startup(pluginPathLocation, location, args, null);
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        return InternalBootLoader.startup(pluginPathLocation, location, args, handler);
    }
}

