/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.internal.boot.BundleStats;
import org.eclipse.core.internal.boot.ClassStats;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.InternalBootLoader;

public class ClassloaderStats {
    private String id;
    private long loadingTime;
    private int failureCount = 0;
    private Map classes = new HashMap(20);
    private ArrayList bundles = new ArrayList(2);
    private boolean keepTraces = false;
    private static ArrayList packageFilters = new ArrayList(4);
    private static Set pluginFilters = new HashSet(5);
    private static Stack classStack = new Stack();
    private static Map loaders = new HashMap(20);
    public static File traceFile;

    static {
        if (DelegatingURLClassLoader.TRACE_CLASSES || DelegatingURLClassLoader.TRACE_PLUGINS) {
            ClassloaderStats.initializeTraceOptions();
        }
    }

    private static void initializeTraceOptions() {
        String filename = DelegatingURLClassLoader.TRACE_FILENAME;
        traceFile = new File(filename);
        traceFile.delete();
        if (!DelegatingURLClassLoader.TRACE_CLASSES) {
            return;
        }
        filename = DelegatingURLClassLoader.TRACE_FILTERS;
        if (filename.length() == 0) {
            return;
        }
        try {
            File filterFile = new File(filename);
            if (!filterFile.isAbsolute()) {
                filterFile = new File(String.valueOf(InternalBootLoader.getBootDir()) + filename);
            }
            System.out.print("Runtime tracing elements defined in: " + filterFile.getAbsolutePath() + "...");
            FileInputStream input = new FileInputStream(filterFile);
            System.out.println("  Loaded.");
            Properties filters = new Properties(){

                public Object put(Object key, Object value) {
                    ClassloaderStats.addFilters((String)key, (String)value);
                    return null;
                }
            };
            try {
                filters.load(input);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                ((InputStream)input).close();
                throw throwable;
            }
            Object var4_6 = null;
            ((InputStream)input).close();
        }
        catch (IOException iOException) {
            System.out.println("  Failed to load.");
        }
    }

    private static void addFilters(String key, String value) {
        String[] filters = DelegatingURLClassLoader.getArrayFromList(value);
        if ("plugins".equals(key)) {
            pluginFilters.addAll(Arrays.asList(filters));
        }
        if ("packages".equals(key)) {
            packageFilters.addAll(Arrays.asList(filters));
        }
    }

    public static void startLoadingClass(String id, String className) {
        ClassloaderStats.findLoader(id).startLoadClass(className);
    }

    private static ClassloaderStats findLoader(String id) {
        ClassloaderStats result = (ClassloaderStats)loaders.get(id);
        if (result == null) {
            result = new ClassloaderStats(id);
            loaders.put(id, result);
        }
        return result;
    }

    public static Stack getClassStack() {
        return classStack;
    }

    public static ClassloaderStats[] getLoaders() {
        return loaders.values().toArray(new ClassloaderStats[loaders.size()]);
    }

    public static void endLoadingClass(String id, String className, boolean success) {
        ClassloaderStats.findLoader(id).endLoadClass(className, success);
    }

    public static void loadedBundle(String id, BundleStats info) {
        ClassloaderStats.findLoader(id).loadedBundle(info);
    }

    public static ClassloaderStats getLoader(String id) {
        return (ClassloaderStats)loaders.get(id);
    }

    public ClassloaderStats(String id) {
        this.id = id;
        this.keepTraces = pluginFilters.contains(id);
    }

    public void addBaseClasses(String[] baseClasses) {
        if (!this.id.equals("org.eclipse.core.boot")) {
            return;
        }
        int i = 0;
        while (i < baseClasses.length) {
            String name = baseClasses[i];
            if (this.classes.get(name) == null) {
                ClassStats value = new ClassStats(name, this);
                value.toBaseClass();
                this.classes.put(name, value);
            }
            ++i;
        }
    }

    private void loadedBundle(BundleStats bundle) {
        this.bundles.add(bundle);
    }

    public ArrayList getBundles() {
        return this.bundles;
    }

    private void startLoadClass(String name) {
        classStack.push(this.findClass(name));
    }

    private ClassStats findClass(String name) {
        ClassStats result = (ClassStats)this.classes.get(name);
        return result == null ? new ClassStats(name, this) : result;
    }

    private void endLoadClass(String name, boolean success) {
        ClassStats current = (ClassStats)classStack.pop();
        if (!success) {
            ++this.failureCount;
            return;
        }
        if (current.getLoadOrder() >= 0) {
            return;
        }
        this.classes.put(name, current);
        current.setLoadOrder(this.classes.size());
        current.loadingDone();
        this.traceLoad(name, current);
        if (classStack.size() != 0) {
            ClassStats previous = (ClassStats)classStack.peek();
            previous.addTimeLoadingOthers(current.getTimeLoading());
            current.setLoadedBy(previous);
            previous.loaded(current);
        } else {
            this.loadingTime += current.getTimeLoading();
        }
    }

    private void traceLoad(String name, ClassStats target) {
        int i;
        if (!this.keepTraces) {
            boolean found = false;
            i = 0;
            while (!found && i < packageFilters.size()) {
                if (name.startsWith((String)packageFilters.get(i))) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                return;
            }
        }
        try {
            target.setTraceStart(traceFile.length());
            PrintWriter output = new PrintWriter(new FileOutputStream(traceFile.getAbsolutePath(), true));
            try {
                output.println("Loading class: " + name);
                output.println("Class loading stack:");
                output.println("\t" + name);
                i = classStack.size() - 1;
                while (i >= 0) {
                    output.println("\t" + ((ClassStats)classStack.get(i)).getClassName());
                    --i;
                }
                output.println("Stack trace:");
                new Throwable().printStackTrace(output);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                output.close();
                throw throwable;
            }
            Object var5_9 = null;
            output.close();
            target.setTraceEnd(traceFile.length());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public int getClassLoadCount() {
        return this.classes.size();
    }

    public long getClassLoadTime() {
        return this.loadingTime;
    }

    public ClassStats[] getClasses() {
        return this.classes.values().toArray(new ClassStats[this.classes.size()]);
    }

    public String getId() {
        return this.id;
    }
}

