/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.PlatformClassLoader;
import org.eclipse.core.internal.boot.PlatformConfiguration;
import org.eclipse.core.internal.boot.PlatformURLBaseConnection;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.PlatformURLHandlerFactory;
import org.eclipse.core.internal.boot.Policy;
import org.eclipse.core.internal.boot.URLContentFilter;

public final class InternalBootLoader {
    private static boolean running = false;
    private static boolean starting = false;
    private static String[] commandLine;
    private static ClassLoader loader;
    private static String baseLocation;
    private static String installLocation;
    private static String applicationR10;
    private static URL installURL;
    private static boolean debugRequested;
    private static String devClassPath;
    private static String debugOptionsFilename;
    private static Properties options;
    private static boolean inDevelopmentMode;
    private static PlatformConfiguration currentPlatformConfiguration;
    private static String nl;
    private static String ws;
    private static String os;
    private static String arch;
    private static final String PLATFORM_ENTRYPOINT = "org.eclipse.core.internal.runtime.InternalPlatform";
    private static final String BOOTNAME = "org.eclipse.core.boot";
    static final String RUNTIMENAME = "org.eclipse.core.runtime";
    private static final String PLUGINSDIR = "plugins/";
    private static final String LIBRARY = "library";
    private static final String EXPORT = "export";
    private static final String EXPORT_PUBLIC = "public";
    private static final String EXPORT_PROTECTED = "protected";
    private static final String META_AREA = ".metadata";
    private static final String WORKSPACE = "workspace";
    private static final String PLUGIN_PATH = ".plugin-path";
    private static String BOOTDIR;
    private static final String RUNTIMEDIR = "plugins/org.eclipse.core.runtime/";
    private static final String OPTIONS = ".options";
    private static final String INTERNAL_OS_SUNOS = "SunOS";
    private static final String INTERNAL_ARCH_I386 = "i386";
    private static boolean useClassLoaderProperties;
    private static String classLoaderPropertiesFilename;
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String OPTION_STARTTIME = "org.eclipse.core.runtime/starttime";
    private static final String OPTION_LOADER_DEBUG = "org.eclipse.core.runtime/loader/debug";
    private static final String OPTION_LOADER_SHOW_CREATE = "org.eclipse.core.runtime/loader/debug/create";
    private static final String OPTION_LOADER_PROPERTIES = "org.eclipse.core.runtime/loader/debug/properties";
    private static final String OPTION_LOADER_PACKAGE_PREFIXES = "org.eclipse.core.runtime/loader/debug/prefixes";
    private static final String OPTION_LOADER_PACKAGE_PREFIXES_SUCCESS = "org.eclipse.core.runtime/loader/debug/prefixes/success";
    private static final String OPTION_LOADER_PACKAGE_PREFIXES_FAILURE = "org.eclipse.core.runtime/loader/debug/prefixes/failure";
    private static final String OPTION_LOADER_SHOW_ACTIVATE = "org.eclipse.core.runtime/loader/debug/activateplugin";
    private static final String OPTION_LOADER_SHOW_ACTIONS = "org.eclipse.core.runtime/loader/debug/actions";
    private static final String OPTION_LOADER_SHOW_SUCCESS = "org.eclipse.core.runtime/loader/debug/success";
    private static final String OPTION_LOADER_SHOW_FAILURE = "org.eclipse.core.runtime/loader/debug/failure";
    private static final String OPTION_LOADER_FILTER_CLASS = "org.eclipse.core.runtime/loader/debug/filter/class";
    private static final String OPTION_LOADER_FILTER_LOADER = "org.eclipse.core.runtime/loader/debug/filter/loader";
    private static final String OPTION_LOADER_FILTER_RESOURCE = "org.eclipse.core.runtime/loader/debug/filter/resource";
    private static final String OPTION_LOADER_FILTER_NATIVE = "org.eclipse.core.runtime/loader/debug/filter/native";
    private static final String OPTION_URL_DEBUG = "org.eclipse.core.runtime/url/debug";
    private static final String OPTION_URL_DEBUG_CONNECT = "org.eclipse.core.runtime/url/debug/connect";
    private static final String OPTION_URL_DEBUG_CACHE_LOOKUP = "org.eclipse.core.runtime/url/debug/cachelookup";
    private static final String OPTION_URL_DEBUG_CACHE_COPY = "org.eclipse.core.runtime/url/debug/cachecopy";
    private static final String OPTION_UPDATE_DEBUG = "org.eclipse.core.runtime/update/debug";
    private static final String OPTION_CONFIGURATION_DEBUG = "org.eclipse.core.runtime/config/debug";
    private static final String OPTION_MONITOR_PLUGINS = "org.eclipse.core.boot/monitor/plugins";
    private static final String OPTION_MONITOR_CLASSES = "org.eclipse.core.boot/monitor/classes";
    private static final String OPTION_MONITOR_BUNDLES = "org.eclipse.core.boot/monitor/bundles";
    private static final String OPTION_TRACE_CLASSES = "org.eclipse.core.boot/trace/classLoading";
    private static final String OPTION_TRACE_FILENAME = "org.eclipse.core.boot/trace/filename";
    private static final String OPTION_TRACE_FILTERS = "org.eclipse.core.boot/trace/filters";
    private static final String OPTION_TRACE_PLUGINS = "org.eclipse.core.boot/trace/pluginActivation";
    private static final String DEBUG = "-debug";
    private static final String DATA = "-data";
    private static final String INSTALL = "-install";
    private static final String DEV = "-dev";
    private static final String WS = "-ws";
    private static final String OS = "-os";
    private static final String ARCH = "-arch";
    private static final String NL = "-nl";
    private static final String CLASSLOADER_PROPERTIES = "-classloaderProperties";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        loader = null;
        baseLocation = null;
        installLocation = null;
        applicationR10 = null;
        installURL = null;
        debugRequested = false;
        devClassPath = null;
        debugOptionsFilename = null;
        options = null;
        inDevelopmentMode = false;
        currentPlatformConfiguration = null;
        nl = null;
        ws = null;
        os = null;
        arch = null;
        useClassLoaderProperties = false;
        classLoaderPropertiesFilename = null;
    }

    private InternalBootLoader() {
    }

    private static void assertNotRunning() {
        if (running) {
            throw new RuntimeException(Policy.bind("platform.mustNotBeRunning"));
        }
    }

    private static void assertRunning() {
        if (!running) {
            throw new RuntimeException(Policy.bind("platform.notRunning"));
        }
    }

    private static PlatformClassLoader configurePlatformLoader() {
        Object[] loadPath = InternalBootLoader.getPlatformClassLoaderPath();
        URL base = null;
        try {
            base = new URL("platform:/base/plugins/org.eclipse.core.runtime/");
        }
        catch (MalformedURLException malformedURLException) {}
        URL[] uRLArray = (URL[])loadPath[0];
        URLContentFilter[] uRLContentFilterArray = (URLContentFilter[])loadPath[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.boot.InternalBootLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new PlatformClassLoader(uRLArray, uRLContentFilterArray, clazz.getClassLoader(), base);
    }

    public static boolean containsSavedPlatform(String location) {
        return new File(String.valueOf(location) + "/" + META_AREA).exists();
    }

    private static String[] getArrayFromList(String prop) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(prop, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    private static boolean getBooleanOption(String option, boolean defaultValue) {
        String optionValue = options.getProperty(option);
        return optionValue == null ? defaultValue : optionValue.equalsIgnoreCase("true");
    }

    public static String[] getCommandLineArgs() {
        return commandLine;
    }

    public static PlatformConfiguration getCurrentPlatformConfiguration() {
        return PlatformConfiguration.getCurrent();
    }

    public static URL getInstallURL() {
        URL url;
        String path;
        Class<?> clazz;
        if (installURL != null) {
            return installURL;
        }
        if (installLocation != null && !installLocation.trim().equals("")) {
            try {
                installURL = new URL(installLocation);
                if (debugRequested) {
                    System.out.println("Install URL:\n    " + installURL.toExternalForm());
                }
                return installURL;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.boot.InternalBootLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((path = InternalBootLoader.decode((url = clazz.getProtectionDomain().getCodeSource().getLocation()).getFile())).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        int ix = path.lastIndexOf(47);
        path = path.substring(0, ix);
        ix = path.lastIndexOf(47);
        path = path.substring(0, ix);
        ix = path.lastIndexOf(47);
        path = path.substring(0, ix + 1);
        try {
            installURL = url.getProtocol().equals("jar") ? new URL(path) : new URL(url.getProtocol(), url.getHost(), url.getPort(), path);
            if (debugRequested) {
                System.out.println("Install URL: " + installURL.toExternalForm());
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(Policy.bind("error.fatal", e.getMessage()));
        }
        return installURL;
    }

    static void initializeBootDir() {
        URL url;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.boot.InternalBootLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((BOOTDIR = InternalBootLoader.decode((url = clazz.getProtectionDomain().getCodeSource().getLocation()).getFile())).endsWith("/")) {
            BOOTDIR = BOOTDIR.substring(0, BOOTDIR.length() - 1);
        }
        int index = BOOTDIR.lastIndexOf(47);
        BOOTDIR = BOOTDIR.substring(0, index + 1);
    }

    public static String decode(String urlString) {
        try {
            Object result;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.net.URLDecoder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            Class[] classArray = new Class[2];
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz3;
            Class<?> clazz4 = class$2;
            if (clazz4 == null) {
                try {
                    clazz4 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz4;
            Method method = clazz2.getDeclaredMethod("decode", classArray);
            if (urlString.indexOf(43) >= 0) {
                int len = urlString.length();
                StringBuffer buf = new StringBuffer(len);
                int i = 0;
                while (i < len) {
                    char c = urlString.charAt(i);
                    if (c == '+') {
                        buf.append("%2B");
                    } else {
                        buf.append(c);
                    }
                    ++i;
                }
                urlString = buf.toString();
            }
            if ((result = method.invoke(null, urlString, "UTF-8")) != null) {
                return (String)result;
            }
        }
        catch (Exception exception) {}
        boolean replaced = false;
        byte[] encodedBytes = urlString.getBytes();
        int encodedLength = encodedBytes.length;
        byte[] decodedBytes = new byte[encodedLength];
        int decodedLength = 0;
        int i = 0;
        while (i < encodedLength) {
            byte b = encodedBytes[i];
            if (b == 37) {
                byte enc1 = encodedBytes[++i];
                byte enc2 = encodedBytes[++i];
                b = (byte)((InternalBootLoader.hexToByte(enc1) << 4) + InternalBootLoader.hexToByte(enc2));
                replaced = true;
            }
            decodedBytes[decodedLength++] = b;
            ++i;
        }
        if (!replaced) {
            return urlString;
        }
        try {
            return new String(decodedBytes, 0, decodedLength, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(decodedBytes, 0, decodedLength);
        }
    }

    private static String[] getListOption(String option) {
        String filter = options.getProperty(option);
        if (filter == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(filter, " ,\t\n\r\f");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getOSArch() {
        return arch;
    }

    public static String getNL() {
        return nl;
    }

    public static String getOS() {
        return os;
    }

    public static PlatformConfiguration getPlatformConfiguration(URL url) throws IOException {
        return new PlatformConfiguration(url);
    }

    private static Object[] getPlatformClassLoaderPath() {
        PlatformConfiguration config = InternalBootLoader.getCurrentPlatformConfiguration();
        PlatformConfiguration.BootDescriptor bd = config.getPluginBootDescriptor("org.eclipse.core.runtime");
        String execBase = bd.getPluginDirectoryURL().toExternalForm();
        if (execBase == null) {
            execBase = InternalBootLoader.getInstallURL() + RUNTIMEDIR;
        }
        ArrayList<Object> libSpecs = new ArrayList<Object>(5);
        String[] exportAll = new String[]{"*"};
        if (DelegatingURLClassLoader.devClassPath != null) {
            String[] specs = InternalBootLoader.getArrayFromList(DelegatingURLClassLoader.devClassPath);
            int j = 0;
            while (j < specs.length) {
                libSpecs.add(String.valueOf(execBase) + specs[j] + "/");
                libSpecs.add(exportAll);
                ++j;
            }
        }
        ArrayList<Object> list = new ArrayList<Object>(5);
        String[] libs = bd.getLibraries();
        int i = 0;
        while (i < libs.length) {
            list.add(libs[i]);
            list.add(exportAll);
            ++i;
        }
        Iterator i2 = ((AbstractList)list).iterator();
        while (i2.hasNext()) {
            String library = (String)i2.next();
            String[] filters = (String[])i2.next();
            String libSpec = String.valueOf(execBase) + library.replace(File.separatorChar, '/');
            if (!libSpec.endsWith("/")) {
                libSpec = libSpec.startsWith("platform:") ? String.valueOf(libSpec) + "!/" : "jar:" + libSpec + "!/";
            }
            libSpecs.add(libSpec);
            libSpecs.add(filters);
        }
        ArrayList<URL> urls = new ArrayList<URL>(5);
        ArrayList<URLContentFilter> cfs = new ArrayList<URLContentFilter>(5);
        Iterator it = ((AbstractList)libSpecs).iterator();
        while (it.hasNext()) {
            try {
                urls.add(new URL((String)it.next()));
                cfs.add(new URLContentFilter((String[])it.next()));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        Object[] result = new Object[]{urls.toArray(new URL[urls.size()]), cfs.toArray(new URLContentFilter[cfs.size()])};
        return result;
    }

    public static URL[] getPluginPath(URL pluginPathLocation) {
        InputStream input = null;
        if (pluginPathLocation == null) {
            return null;
        }
        try {
            input = pluginPathLocation.openStream();
        }
        catch (IOException iOException) {}
        if (input == null) {
            try {
                URL url = new URL("platform:/base/.plugin-path");
                input = url.openStream();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        if (input == null) {
            return null;
        }
        URL[] result = null;
        try {
            try {
                result = InternalBootLoader.readPluginPath(input);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                input.close();
                throw throwable;
            }
            Object var3_5 = null;
            input.close();
        }
        catch (IOException iOException) {}
        return result;
    }

    public static IPlatformRunnable getRunnable(String applicationName) throws Exception {
        InternalBootLoader.assertRunning();
        Class<?> platform = loader.loadClass(PLATFORM_ENTRYPOINT);
        Class[] classArray = new Class[1];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Method method = platform.getDeclaredMethod("loaderGetRunnable", classArray);
        try {
            return (IPlatformRunnable)method.invoke(platform, applicationName);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
    }

    public static IPlatformRunnable getRunnable(String pluginId, String className, Object args) throws Exception {
        InternalBootLoader.assertRunning();
        Class<?> platform = loader.loadClass(PLATFORM_ENTRYPOINT);
        Class[] classArray = new Class[3];
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Method method = platform.getDeclaredMethod("loaderGetRunnable", classArray);
        try {
            return (IPlatformRunnable)method.invoke(platform, pluginId, className, args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
    }

    public static String getWS() {
        return ws;
    }

    private static int hexToByte(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        throw new IllegalArgumentException("Switch error decoding URL");
    }

    public static boolean inDebugMode() {
        return debugRequested;
    }

    public static boolean inDevelopmentMode() {
        return inDevelopmentMode;
    }

    private static String[] initialize(URL pluginPathLocation, String location, String[] args) throws Exception {
        if (running) {
            throw new RuntimeException(Policy.bind("platform.running"));
        }
        baseLocation = location;
        String[] appArgs = InternalBootLoader.processCommandLine(args);
        InternalBootLoader.setupSystemContext();
        InternalBootLoader.initializeBootDir();
        DelegatingURLClassLoader.devClassPath = devClassPath;
        if (baseLocation == null) {
            baseLocation = System.getProperty("user.dir");
            if (!baseLocation.endsWith(File.separator)) {
                baseLocation = String.valueOf(baseLocation) + File.separator;
            }
            baseLocation = String.valueOf(baseLocation) + WORKSPACE;
        }
        if (debugRequested) {
            System.out.println("Workspace location:\n   " + baseLocation);
        }
        InternalBootLoader.loadOptions();
        String metaPath = baseLocation.replace(File.separatorChar, '/');
        if (!metaPath.endsWith("/")) {
            metaPath = String.valueOf(metaPath) + "/";
        }
        metaPath = String.valueOf(metaPath) + META_AREA;
        PlatformURLHandlerFactory.startup(metaPath);
        PlatformURLBaseConnection.startup(InternalBootLoader.getInstallURL());
        appArgs = PlatformConfiguration.startup(appArgs, pluginPathLocation, applicationR10, metaPath);
        loader = InternalBootLoader.configurePlatformLoader();
        return appArgs;
    }

    public static boolean isRunning() {
        return running;
    }

    public static boolean isStarting() {
        return starting;
    }

    public static boolean useClassLoaderProperties() {
        return useClassLoaderProperties;
    }

    static String getClassLoaderPropertiesFilename() {
        return classLoaderPropertiesFilename;
    }

    static String getDefaultClassLoaderPropertiesFilename() {
        return String.valueOf(BOOTDIR) + "classloader.properties";
    }

    private static void loadOptions() {
        URL optionsFile;
        if (!debugRequested) {
            options = null;
            return;
        }
        options = new Properties();
        if (debugOptionsFilename == null) {
            String userDir = System.getProperty("user.dir").replace(File.separatorChar, '/');
            if (!userDir.endsWith("/")) {
                userDir = String.valueOf(userDir) + "/";
            }
            debugOptionsFilename = "file:" + userDir + OPTIONS;
        }
        try {
            optionsFile = InternalBootLoader.getURL(debugOptionsFilename);
        }
        catch (MalformedURLException e) {
            System.out.println("Unable to construct URL for options file: " + debugOptionsFilename);
            e.printStackTrace(System.out);
            return;
        }
        System.out.println("Debug-Options:\n    " + debugOptionsFilename);
        try {
            InputStream input = optionsFile.openStream();
            try {
                options.load(input);
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                input.close();
                throw throwable;
            }
            Object var2_6 = null;
            input.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            System.out.println("Could not parse the options file: " + optionsFile);
            e.printStackTrace(System.out);
        }
        Iterator i = ((Hashtable)options).keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            ((Hashtable)options).put(key, ((String)((Hashtable)options).get(key)).trim());
        }
        InternalBootLoader.setupOptions();
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(DEBUG) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                found = true;
                debugRequested = true;
            }
            if (args[i].equalsIgnoreCase(CLASSLOADER_PROPERTIES) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                useClassLoaderProperties = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(DEV) && (i + 1 == args.length || i + 1 < args.length && args[i + 1].startsWith("-"))) {
                inDevelopmentMode = true;
                found = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(DEBUG)) {
                    found = true;
                    debugRequested = true;
                    debugOptionsFilename = arg;
                }
                if (args[i - 1].equalsIgnoreCase(CLASSLOADER_PROPERTIES)) {
                    found = true;
                    useClassLoaderProperties = true;
                    classLoaderPropertiesFilename = arg;
                }
                if (args[i - 1].equalsIgnoreCase(DEV)) {
                    inDevelopmentMode = true;
                    devClassPath = arg;
                    found = true;
                } else {
                    if (args[i - 1].equalsIgnoreCase(INSTALL)) {
                        found = true;
                        installLocation = arg;
                    }
                    if (args[i - 1].equalsIgnoreCase(DATA)) {
                        found = true;
                        if (baseLocation == null) {
                            baseLocation = arg;
                        }
                    }
                    if (args[i - 1].equalsIgnoreCase(WS)) {
                        found = true;
                        ws = arg;
                    }
                    if (args[i - 1].equalsIgnoreCase(OS)) {
                        found = true;
                        os = arg;
                    }
                    if (args[i - 1].equalsIgnoreCase(ARCH)) {
                        found = true;
                        arch = arg;
                    }
                    if (args[i - 1].equalsIgnoreCase(NL)) {
                        found = true;
                        nl = arg;
                    }
                    if (found) {
                        configArgs[configArgIndex++] = i - 1;
                        configArgs[configArgIndex++] = i;
                    }
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private static URL[] readPluginPath(InputStream input) {
        Properties ini = new Properties();
        try {
            ini.load(input);
        }
        catch (IOException iOException) {
            return null;
        }
        Vector<URL> result = new Vector<URL>(5);
        Enumeration<?> groups = ini.propertyNames();
        while (groups.hasMoreElements()) {
            String group = (String)groups.nextElement();
            StringTokenizer entries = new StringTokenizer(ini.getProperty(group), ";");
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                if (entry.equals("")) continue;
                try {
                    result.addElement(new URL(entry));
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println(Policy.bind("ignore.plugin", entry));
                }
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public static URL resolve(URL url) throws IOException {
        if (!url.getProtocol().equals("platform")) {
            return url;
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof PlatformURLConnection) {
            return ((PlatformURLConnection)connection).getResolvedURL();
        }
        return url;
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args) throws Exception {
        return InternalBootLoader.run(applicationName, pluginPathLocation, location, args, null);
    }

    public static Object run(String applicationName, URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        Object result = null;
        applicationR10 = applicationName;
        String[] applicationArgs = InternalBootLoader.startup(pluginPathLocation, location, args, handler);
        String application = InternalBootLoader.getCurrentPlatformConfiguration().getApplicationIdentifier();
        IPlatformRunnable runnable = InternalBootLoader.getRunnable(application);
        if (runnable == null) {
            throw new IllegalArgumentException(Policy.bind("application.notFound", application));
        }
        try {
            try {
                result = runnable.run(applicationArgs);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {}
        InternalBootLoader.shutdown();
        return result;
    }

    public static void setupOptions() {
        if (!debugRequested) {
            return;
        }
        ((Hashtable)options).put(OPTION_STARTTIME, Long.toString(System.currentTimeMillis()));
        DelegatingURLClassLoader.DEBUG = InternalBootLoader.getBooleanOption(OPTION_LOADER_DEBUG, false);
        DelegatingURLClassLoader.DEBUG_SHOW_CREATE = InternalBootLoader.getBooleanOption(OPTION_LOADER_SHOW_CREATE, true);
        DelegatingURLClassLoader.DEBUG_SHOW_ACTIVATE = InternalBootLoader.getBooleanOption(OPTION_LOADER_SHOW_ACTIVATE, true);
        DelegatingURLClassLoader.DEBUG_SHOW_ACTIONS = InternalBootLoader.getBooleanOption(OPTION_LOADER_SHOW_ACTIONS, true);
        DelegatingURLClassLoader.DEBUG_SHOW_SUCCESS = InternalBootLoader.getBooleanOption(OPTION_LOADER_SHOW_SUCCESS, true);
        DelegatingURLClassLoader.DEBUG_SHOW_FAILURE = InternalBootLoader.getBooleanOption(OPTION_LOADER_SHOW_FAILURE, true);
        DelegatingURLClassLoader.DEBUG_FILTER_CLASS = InternalBootLoader.getListOption(OPTION_LOADER_FILTER_CLASS);
        DelegatingURLClassLoader.DEBUG_FILTER_LOADER = InternalBootLoader.getListOption(OPTION_LOADER_FILTER_LOADER);
        DelegatingURLClassLoader.DEBUG_FILTER_RESOURCE = InternalBootLoader.getListOption(OPTION_LOADER_FILTER_RESOURCE);
        DelegatingURLClassLoader.DEBUG_FILTER_NATIVE = InternalBootLoader.getListOption(OPTION_LOADER_FILTER_NATIVE);
        PlatformURLConnection.DEBUG = InternalBootLoader.getBooleanOption(OPTION_URL_DEBUG, false);
        PlatformURLConnection.DEBUG_CONNECT = InternalBootLoader.getBooleanOption(OPTION_URL_DEBUG_CONNECT, true);
        PlatformURLConnection.DEBUG_CACHE_LOOKUP = InternalBootLoader.getBooleanOption(OPTION_URL_DEBUG_CACHE_LOOKUP, true);
        PlatformURLConnection.DEBUG_CACHE_COPY = InternalBootLoader.getBooleanOption(OPTION_URL_DEBUG_CACHE_COPY, true);
        PlatformConfiguration.DEBUG = InternalBootLoader.getBooleanOption(OPTION_CONFIGURATION_DEBUG, false);
        DelegatingURLClassLoader.MONITOR_PLUGINS = InternalBootLoader.getBooleanOption(OPTION_MONITOR_PLUGINS, DelegatingURLClassLoader.MONITOR_PLUGINS);
        DelegatingURLClassLoader.MONITOR_CLASSES = InternalBootLoader.getBooleanOption(OPTION_MONITOR_CLASSES, DelegatingURLClassLoader.MONITOR_CLASSES);
        DelegatingURLClassLoader.MONITOR_BUNDLES = InternalBootLoader.getBooleanOption(OPTION_MONITOR_BUNDLES, DelegatingURLClassLoader.MONITOR_BUNDLES);
        DelegatingURLClassLoader.TRACE_FILENAME = options.getProperty(OPTION_TRACE_FILENAME, DelegatingURLClassLoader.TRACE_FILENAME);
        DelegatingURLClassLoader.TRACE_FILTERS = options.getProperty(OPTION_TRACE_FILTERS, DelegatingURLClassLoader.TRACE_FILTERS);
        DelegatingURLClassLoader.TRACE_CLASSES = InternalBootLoader.getBooleanOption(OPTION_TRACE_CLASSES, DelegatingURLClassLoader.TRACE_CLASSES);
        DelegatingURLClassLoader.TRACE_PLUGINS = InternalBootLoader.getBooleanOption(OPTION_TRACE_PLUGINS, DelegatingURLClassLoader.TRACE_PLUGINS);
        DelegatingURLClassLoader.DEBUG_PROPERTIES = InternalBootLoader.getBooleanOption(OPTION_LOADER_PROPERTIES, DelegatingURLClassLoader.DEBUG_PROPERTIES);
        DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES = InternalBootLoader.getBooleanOption(OPTION_LOADER_PACKAGE_PREFIXES, DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES);
        DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES_SUCCESS = InternalBootLoader.getBooleanOption(OPTION_LOADER_PACKAGE_PREFIXES_SUCCESS, DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES_SUCCESS);
        DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES_FAILURE = InternalBootLoader.getBooleanOption(OPTION_LOADER_PACKAGE_PREFIXES_FAILURE, DelegatingURLClassLoader.DEBUG_PACKAGE_PREFIXES_FAILURE);
    }

    private static void setupSystemContext() {
        String name;
        if (nl != null) {
            StringTokenizer tokenizer = new StringTokenizer(nl, "_");
            int segments = tokenizer.countTokens();
            try {
                switch (segments) {
                    case 2: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                        break;
                    }
                    case 3: {
                        Locale userLocale = new Locale(tokenizer.nextToken(), tokenizer.nextToken(), tokenizer.nextToken());
                        Locale.setDefault(userLocale);
                    }
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        nl = Locale.getDefault().toString();
        if (os == null) {
            name = System.getProperty("os.name");
            if (name.regionMatches(true, 0, "win32", 0, 3)) {
                os = "win32";
            }
            if (os == null) {
                String string = os = name.equalsIgnoreCase(INTERNAL_OS_SUNOS) ? "solaris" : "unknown";
            }
        }
        if (ws == null) {
            ws = os.equals("win32") ? "win32" : (os.equals("linux") ? "motif" : (os.equals("macosx") ? "carbon" : (os.equals("hpux") ? "motif" : (os.equals("aix") ? "motif" : (os.equals("solaris") ? "motif" : "unknown")))));
        }
        if (arch == null) {
            name = System.getProperty("os.arch");
            arch = name.equalsIgnoreCase(INTERNAL_ARCH_I386) ? "x86" : name;
        }
    }

    public static void shutdown() throws Exception {
        InternalBootLoader.assertRunning();
        running = false;
        Class<?> platform = loader.loadClass(PLATFORM_ENTRYPOINT);
        Method method = platform.getDeclaredMethod("loaderShutdown", new Class[0]);
        try {
            try {
                method.invoke(platform, new Object[0]);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof Error) {
                    throw (Error)e.getTargetException();
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            PlatformURLHandlerFactory.shutdown();
            PlatformConfiguration.shutdown();
            loader = null;
            throw throwable;
        }
        Object var3_5 = null;
        PlatformURLHandlerFactory.shutdown();
        PlatformConfiguration.shutdown();
        loader = null;
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args) throws Exception {
        return InternalBootLoader.startup(pluginPathLocation, location, args, null);
    }

    public static String[] startup(URL pluginPathLocation, String location, String[] args, Runnable handler) throws Exception {
        InternalBootLoader.assertNotRunning();
        starting = true;
        commandLine = args;
        String[] applicationArgs = InternalBootLoader.initialize(pluginPathLocation, location, args);
        Class<?> platform = loader.loadClass(PLATFORM_ENTRYPOINT);
        Class[] classArray = new Class[5];
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("[Ljava.net.URL;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.util.Properties");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        Class<?> clazz5 = class$7;
        if (clazz5 == null) {
            try {
                clazz5 = class$7 = Class.forName("java.lang.Runnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz5;
        Method method = platform.getDeclaredMethod("loaderStartup", classArray);
        try {
            URL[] pluginPath = InternalBootLoader.getCurrentPlatformConfiguration().getPluginPath();
            method.invoke(platform, pluginPath, baseLocation, options, args, handler);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw e;
        }
        running = true;
        starting = false;
        return applicationArgs;
    }

    public static String getBootDir() {
        if (BOOTDIR == null) {
            InternalBootLoader.initializeBootDir();
        }
        return BOOTDIR;
    }

    private static URL getURL(String urlString) throws MalformedURLException {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            try {
                return new File(urlString).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw e;
            }
        }
    }
}

