/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.internal.boot.InternalBootLoader;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.internal.boot.Policy;

public class PlatformConfiguration
implements IPlatformConfiguration {
    private static PlatformConfiguration currentPlatformConfiguration = null;
    private URL configLocation;
    private URL rootLocation;
    private HashMap sites = new HashMap();
    private HashMap externalLinkSites = new HashMap();
    private HashMap cfgdFeatures = new HashMap();
    private HashMap bootPlugins = new HashMap();
    private String defaultFeature;
    private long lastChangeStamp;
    private long changeStamp;
    private boolean changeStampIsValid = false;
    private long lastFeaturesChangeStamp;
    private long featuresChangeStamp;
    private boolean featuresChangeStampIsValid = false;
    private long lastPluginsChangeStamp;
    private long pluginsChangeStamp;
    private boolean pluginsChangeStampIsValid = false;
    private boolean featureChangesConfigured = false;
    private boolean transientConfig = false;
    private File cfgLockFile;
    private RandomAccessFile cfgLockFileRAF;
    private BootDescriptor runtimeDescriptor;
    private BootDescriptor xmlDescriptor;
    private static String cmdConfiguration = null;
    private static String cmdFeature = null;
    private static String cmdApplication = null;
    private static URL cmdPlugins = null;
    private static boolean cmdInitialize = false;
    private static boolean cmdFirstUse = false;
    private static boolean cmdUpdate = false;
    private static boolean cmdNoUpdate = false;
    private static boolean cmdDev = false;
    static boolean DEBUG = false;
    private static final String BOOT_XML = "boot.xml";
    private static final String BOOT_PLUGIN_ID = "org.eclipse.core.boot";
    private static final String RUNTIME_PLUGIN_ID = "org.eclipse.core.runtime";
    private static final String XML_PLUGIN_ID = "org.apache.xerces";
    private static final String ECLIPSE = "eclipse";
    private static final String PLUGINS = "plugins";
    private static final String FEATURES = "features";
    private static final String CONFIG_DIR = ".config";
    private static final String CONFIG_FILE = ".config/platform.cfg";
    private static final String CONFIG_FILE_INIT = "install.ini";
    private static final String CONFIG_FILE_LOCK_SUFFIX = ".lock";
    private static final String CONFIG_FILE_TEMP_SUFFIX = ".tmp";
    private static final String CONFIG_FILE_BAK_SUFFIX = ".bak";
    private static final String CHANGES_MARKER = ".newupdates";
    private static final String LINKS = "links";
    private static final String PLUGIN_XML = "plugin.xml";
    private static final String FRAGMENT_XML = "fragment.xml";
    private static final String FEATURE_XML = "feature.xml";
    private static final String[] BOOTSTRAP_PLUGINS = new String[]{"org.eclipse.core.boot"};
    private static final String CFG_BOOT_PLUGIN = "bootstrap";
    private static final String CFG_SITE = "site";
    private static final String CFG_URL = "url";
    private static final String CFG_POLICY = "policy";
    private static final String[] CFG_POLICY_TYPE = new String[]{"USER-INCLUDE", "USER-EXCLUDE"};
    private static final String CFG_POLICY_TYPE_UNKNOWN = "UNKNOWN";
    private static final String CFG_LIST = "list";
    private static final String CFG_STAMP = "stamp";
    private static final String CFG_FEATURE_STAMP = "stamp.features";
    private static final String CFG_PLUGIN_STAMP = "stamp.plugins";
    private static final String CFG_UPDATEABLE = "updateable";
    private static final String CFG_LINK_FILE = "linkfile";
    private static final String CFG_FEATURE_ENTRY = "feature";
    private static final String CFG_FEATURE_ENTRY_DEFAULT = "feature.default.id";
    private static final String CFG_FEATURE_ENTRY_ID = "id";
    private static final String CFG_FEATURE_ENTRY_PRIMARY = "primary";
    private static final String CFG_FEATURE_ENTRY_VERSION = "version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_VERSION = "plugin-version";
    private static final String CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER = "plugin-identifier";
    private static final String CFG_FEATURE_ENTRY_APPLICATION = "application";
    private static final String CFG_FEATURE_ENTRY_ROOT = "root";
    private static final String INIT_DEFAULT_FEATURE_ID = "feature.default.id";
    private static final String INIT_DEFAULT_PLUGIN_ID = "feature.default.plugin.id";
    private static final String INIT_DEFAULT_FEATURE_APPLICATION = "feature.default.application";
    private static final String DEFAULT_FEATURE_ID = "org.eclipse.platform";
    private static final String DEFAULT_FEATURE_APPLICATION = "org.eclipse.ui.workbench";
    private static final String CFG_VERSION = "version";
    private static final String CFG_TRANSIENT = "transient";
    private static final String VERSION = "1.0";
    private static final String EOF = "eof";
    private static final int CFG_LIST_LENGTH = 10;
    private static final int DEFAULT_POLICY_TYPE = 1;
    private static final String[] DEFAULT_POLICY_LIST = new String[0];
    private static final String LINK_PATH = "path";
    private static final String LINK_READ = "r";
    private static final String LINK_READ_WRITE = "rw";
    private static final String CMD_CONFIGURATION = "-configuration";
    private static final String CMD_FEATURE = "-feature";
    private static final String CMD_APPLICATION = "-application";
    private static final String CMD_PLUGINS = "-plugins";
    private static final String CMD_UPDATE = "-update";
    private static final String CMD_INITIALIZE = "-initialize";
    private static final String CMD_FIRSTUSE = "-firstuse";
    private static final String CMD_NO_UPDATE = "-noupdate";
    private static final String CMD_NEW_UPDATES = "-newUpdates";
    private static final String CMD_DEV = "-dev";
    private static final String RECONCILER_APP = "org.eclipse.update.core.reconciler";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static /* synthetic */ Class class$0;

    private PlatformConfiguration(String configArg, String metaPath, URL pluginPath) throws IOException {
        URL configURL = null;
        if (configArg != null && !configArg.trim().equals("")) {
            configURL = new URL(configArg);
        }
        boolean createRootSite = pluginPath == null;
        this.initializeCurrent(configURL, metaPath, createRootSite);
        if (pluginPath != null) {
            this.updateConfigurationFromPlugins(pluginPath);
        }
        this.loadInitializationAttributes();
        this.configureExternalLinks();
        this.validateSites();
        this.computeChangeStamp();
        this.locateDefaultPlugins();
    }

    PlatformConfiguration(URL url) throws IOException {
        this.initialize(url);
    }

    public IPlatformConfiguration.ISiteEntry createSiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy) {
        return new SiteEntry(url, policy, this);
    }

    public IPlatformConfiguration.ISitePolicy createSitePolicy(int type, String[] list) {
        return new SitePolicy(type, list);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginVersion, primary, application, root);
    }

    public IPlatformConfiguration.IFeatureEntry createFeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
        return new FeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, root);
    }

    public void configureSite(IPlatformConfiguration.ISiteEntry entry) {
        this.configureSite(entry, false);
    }

    public synchronized void configureSite(IPlatformConfiguration.ISiteEntry entry, boolean replace) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        if (this.sites.containsKey(key) && !replace) {
            return;
        }
        this.sites.put(key, entry);
    }

    public synchronized void unconfigureSite(IPlatformConfiguration.ISiteEntry entry) {
        if (entry == null) {
            return;
        }
        URL url = entry.getURL();
        if (url == null) {
            return;
        }
        String key = url.toExternalForm();
        this.sites.remove(key);
    }

    public IPlatformConfiguration.ISiteEntry[] getConfiguredSites() {
        if (this.sites.size() == 0) {
            return new IPlatformConfiguration.ISiteEntry[0];
        }
        return this.sites.values().toArray(new IPlatformConfiguration.ISiteEntry[0]);
    }

    public IPlatformConfiguration.ISiteEntry findConfiguredSite(URL url) {
        if (url == null) {
            return null;
        }
        String key = url.toExternalForm();
        IPlatformConfiguration.ISiteEntry result = (IPlatformConfiguration.ISiteEntry)this.sites.get(key);
        if (result == null) {
            result = (IPlatformConfiguration.ISiteEntry)this.sites.get(URLDecoder.decode(key));
        }
        return result;
    }

    public synchronized void configureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.put(key, entry);
    }

    public synchronized void unconfigureFeatureEntry(IPlatformConfiguration.IFeatureEntry entry) {
        if (entry == null) {
            return;
        }
        String key = entry.getFeatureIdentifier();
        if (key == null) {
            return;
        }
        this.cfgdFeatures.remove(key);
    }

    public IPlatformConfiguration.IFeatureEntry[] getConfiguredFeatureEntries() {
        if (this.cfgdFeatures.size() == 0) {
            return new IPlatformConfiguration.IFeatureEntry[0];
        }
        return this.cfgdFeatures.values().toArray(new IPlatformConfiguration.IFeatureEntry[0]);
    }

    public IPlatformConfiguration.IFeatureEntry findConfiguredFeatureEntry(String id) {
        if (id == null) {
            return null;
        }
        return (IPlatformConfiguration.IFeatureEntry)this.cfgdFeatures.get(id);
    }

    public URL getConfigurationLocation() {
        return this.configLocation;
    }

    public long getChangeStamp() {
        if (!this.changeStampIsValid) {
            this.computeChangeStamp();
        }
        return this.changeStamp;
    }

    public long getFeaturesChangeStamp() {
        if (!this.featuresChangeStampIsValid) {
            this.computeFeaturesChangeStamp();
        }
        return this.featuresChangeStamp;
    }

    public long getPluginsChangeStamp() {
        if (!this.pluginsChangeStampIsValid) {
            this.computePluginsChangeStamp();
        }
        return this.pluginsChangeStamp;
    }

    public String getApplicationIdentifier() {
        if (cmdInitialize) {
            return RECONCILER_APP;
        }
        if (this.featuresChangeStamp != this.lastFeaturesChangeStamp) {
            boolean update;
            boolean bl = update = !cmdNoUpdate || cmdUpdate;
            if (update) {
                return RECONCILER_APP;
            }
        }
        return this.getApplicationIdentifierInternal();
    }

    private String getApplicationIdentifierInternal() {
        IPlatformConfiguration.IFeatureEntry fe;
        if (cmdApplication != null) {
            return cmdApplication;
        }
        String feature = cmdFeature;
        if (feature == null) {
            feature = this.defaultFeature;
        }
        if (feature != null && (fe = this.findConfiguredFeatureEntry(feature)) != null && fe.getFeatureApplication() != null) {
            return fe.getFeatureApplication();
        }
        return DEFAULT_FEATURE_APPLICATION;
    }

    public String getPrimaryFeatureIdentifier() {
        if (cmdFeature != null) {
            return cmdFeature;
        }
        if (this.defaultFeature != null) {
            return this.defaultFeature;
        }
        return DEFAULT_FEATURE_ID;
    }

    public URL[] getPluginPath() {
        ArrayList<URL> path = new ArrayList<URL>();
        if (DEBUG) {
            PlatformConfiguration.debug("computed plug-in path:");
        }
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            String[] plugins = sites[i].getPlugins();
            int j = 0;
            while (j < plugins.length) {
                block6: {
                    try {
                        URL pathURL = new URL(((SiteEntry)sites[i]).getResolvedURL(), plugins[j]);
                        path.add(pathURL);
                        if (DEBUG) {
                            PlatformConfiguration.debug("   " + pathURL.toString());
                        }
                    }
                    catch (MalformedURLException e) {
                        if (!DEBUG) break block6;
                        PlatformConfiguration.debug("   bad URL: " + e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return path.toArray(new URL[0]);
    }

    public String[] getBootstrapPluginIdentifiers() {
        return BOOTSTRAP_PLUGINS;
    }

    public void setBootstrapPluginLocation(String id, URL location) {
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals(id)) {
                this.bootPlugins.put(id, location.toExternalForm());
                break;
            }
            ++i;
        }
    }

    public boolean isUpdateable() {
        return true;
    }

    public boolean isTransient() {
        return this.transientConfig;
    }

    public void isTransient(boolean value) {
        if (this != BootLoader.getCurrentPlatformConfiguration()) {
            this.transientConfig = value;
        }
    }

    public synchronized void refresh() {
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            ((SiteEntry)sites[i]).refresh();
            ++i;
        }
        this.lastChangeStamp = this.changeStamp;
        this.lastFeaturesChangeStamp = this.featuresChangeStamp;
        this.lastPluginsChangeStamp = this.pluginsChangeStamp;
        this.changeStampIsValid = false;
        this.featuresChangeStampIsValid = false;
        this.pluginsChangeStampIsValid = false;
    }

    public void save() throws IOException {
        if (this.isUpdateable()) {
            this.save(this.configLocation);
        }
    }

    public synchronized void save(URL url) throws IOException {
        if (url == null) {
            throw new IOException(Policy.bind("cfig.unableToSave.noURL"));
        }
        PrintWriter w = null;
        OutputStream os = null;
        if (!url.getProtocol().equals("file")) {
            URLConnection uc = url.openConnection();
            uc.setDoOutput(true);
            os = uc.getOutputStream();
            w = new PrintWriter(os);
            try {
                this.write(w);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                w.close();
                throw throwable;
            }
            Object var5_9 = null;
            w.close();
        } else {
            boolean ok;
            File cfigFile = new File(url.getFile().replace('/', File.separatorChar));
            File cfigDir = cfigFile.getParentFile();
            if (cfigDir != null) {
                cfigDir.mkdirs();
            }
            File cfigTmp = new File(String.valueOf(cfigFile.getAbsolutePath()) + CONFIG_FILE_TEMP_SUFFIX);
            os = new FileOutputStream(cfigTmp);
            w = new PrintWriter(os);
            try {
                this.write(w);
            }
            catch (Throwable throwable) {
                Object var7_13 = null;
                w.close();
                throw throwable;
            }
            Object var7_14 = null;
            w.close();
            FileInputStream is = new FileInputStream(cfigTmp);
            Properties tmpProps = new Properties();
            try {
                tmpProps.load(is);
                if (!EOF.equals(tmpProps.getProperty(EOF))) {
                    throw new IOException(Policy.bind("cfig.unableToSave", cfigTmp.getAbsolutePath()));
                }
            }
            catch (Throwable throwable) {
                Object var9_17 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            Object var9_18 = null;
            ((InputStream)is).close();
            File cfigBak = new File(String.valueOf(cfigFile.getAbsolutePath()) + CONFIG_FILE_BAK_SUFFIX);
            cfigBak.delete();
            if (cfigFile.exists()) {
                cfigFile.renameTo(cfigBak);
            }
            if (ok = cfigTmp.renameTo(cfigFile)) {
                cfigBak.delete();
            } else {
                throw new IOException(Policy.bind("cfig.unableToSave", cfigTmp.getAbsolutePath()));
            }
        }
    }

    public BootDescriptor getPluginBootDescriptor(String id) {
        if (RUNTIME_PLUGIN_ID.equals(id)) {
            return this.runtimeDescriptor;
        }
        if (XML_PLUGIN_ID.equals(id)) {
            return this.xmlDescriptor;
        }
        return null;
    }

    static PlatformConfiguration getCurrent() {
        return currentPlatformConfiguration;
    }

    static synchronized String[] startup(String[] cmdArgs, URL r10plugins, String r10app, String metaPath) throws Exception {
        cmdPlugins = r10plugins;
        cmdApplication = r10app;
        String[] passthruArgs = PlatformConfiguration.processCommandLine(cmdArgs);
        if (cmdDev) {
            cmdNoUpdate = true;
        }
        if (currentPlatformConfiguration == null) {
            currentPlatformConfiguration = new PlatformConfiguration(cmdConfiguration, metaPath, cmdPlugins);
        }
        passthruArgs = PlatformConfiguration.checkForFeatureChanges(passthruArgs, currentPlatformConfiguration);
        passthruArgs = PlatformConfiguration.checkForNewUpdates(currentPlatformConfiguration, passthruArgs);
        return passthruArgs;
    }

    static synchronized void shutdown() throws IOException {
        PlatformConfiguration config = PlatformConfiguration.getCurrent();
        if (config != null) {
            block3: {
                try {
                    config.save();
                }
                catch (IOException e) {
                    if (!DEBUG) break block3;
                    PlatformConfiguration.debug("Unable to save configuration " + e.toString());
                }
            }
            config.clearConfigurationLock();
        }
    }

    private synchronized void initializeCurrent(URL url, String metaPath, boolean createRootSite) throws IOException {
        if (cmdInitialize) {
            url = new URL(BootLoader.getInstallURL(), CONFIG_FILE);
            this.getConfigurationLock(url);
            this.resetInitializationConfiguration(url);
            if (createRootSite) {
                this.configureSite(this.getRootSite());
            }
            if (DEBUG) {
                PlatformConfiguration.debug("Initializing configuration " + url.toString());
            }
            this.configLocation = url;
            PlatformConfiguration.verifyPath(this.configLocation);
            return;
        }
        if (url != null) {
            block18: {
                this.getConfigurationLock(url);
                try {
                    this.load(url);
                    if (DEBUG) {
                        PlatformConfiguration.debug("Using configuration " + url.toString());
                    }
                }
                catch (IOException iOException) {
                    cmdFirstUse = true;
                    if (createRootSite) {
                        this.configureSite(this.getRootSite());
                    }
                    if (!DEBUG) break block18;
                    PlatformConfiguration.debug("Creating configuration " + url.toString());
                }
            }
            this.configLocation = url;
            PlatformConfiguration.verifyPath(this.configLocation);
            return;
        }
        if (!(metaPath = metaPath.replace(File.separatorChar, '/')).endsWith("/")) {
            metaPath = String.valueOf(metaPath) + "/";
        }
        URL cfigURL = new URL("file", null, 0, String.valueOf(metaPath) + CONFIG_FILE);
        this.getConfigurationLock(cfigURL);
        try {
            this.load(cfigURL);
            this.configLocation = cfigURL;
            PlatformConfiguration.verifyPath(this.configLocation);
            if (DEBUG) {
                PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
            }
            return;
        }
        catch (IOException iOException) {
            cmdFirstUse = true;
            if (createRootSite) {
                try {
                    url = new URL(BootLoader.getInstallURL(), CONFIG_FILE);
                    this.load(url);
                    this.copyInitializedState(BootLoader.getInstallURL(), metaPath, CONFIG_DIR);
                    this.configLocation = cfigURL;
                    PlatformConfiguration.verifyPath(this.configLocation);
                    if (DEBUG) {
                        PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
                        PlatformConfiguration.debug("Initialized from    " + url.toString());
                    }
                    return;
                }
                catch (IOException iOException2) {}
            }
            if (createRootSite) {
                this.configureSite(this.getRootSite());
            }
            this.configLocation = cfigURL;
            PlatformConfiguration.verifyPath(this.configLocation);
            if (DEBUG) {
                PlatformConfiguration.debug("Creating configuration " + this.configLocation.toString());
            }
            return;
        }
    }

    private synchronized void initialize(URL url) throws IOException {
        if (url == null) {
            if (DEBUG) {
                PlatformConfiguration.debug("Creating empty configuration object");
            }
            return;
        }
        this.load(url);
        this.configLocation = url;
        if (DEBUG) {
            PlatformConfiguration.debug("Using configuration " + this.configLocation.toString());
        }
    }

    private IPlatformConfiguration.ISiteEntry getRootSite() {
        IPlatformConfiguration.ISitePolicy defaultPolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        URL siteURL = null;
        try {
            siteURL = new URL("platform:/base/");
        }
        catch (MalformedURLException malformedURLException) {
            siteURL = BootLoader.getInstallURL();
        }
        IPlatformConfiguration.ISiteEntry defaultSite = this.createSiteEntry(siteURL, defaultPolicy);
        return defaultSite;
    }

    private void resetInitializationConfiguration(URL url) throws IOException {
        if (!PlatformConfiguration.supportsDetection(url)) {
            return;
        }
        URL resolved = PlatformConfiguration.resolvePlatformURL(url);
        File initCfg = new File(resolved.getFile().replace('/', File.separatorChar));
        File initDir = initCfg.getParentFile();
        this.resetInitializationLocation(initDir);
    }

    private void resetInitializationLocation(File dir) {
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] list = dir.listFiles();
        int i = 0;
        while (i < list.length) {
            if (list[i].isDirectory()) {
                this.resetInitializationLocation(list[i]);
            }
            list[i].delete();
            ++i;
        }
    }

    private boolean getConfigurationLock(URL url) {
        if (this.configurationInWorkspace(url)) {
            return false;
        }
        if (!url.getProtocol().equals("file")) {
            return false;
        }
        PlatformConfiguration.verifyPath(url);
        String cfgName = url.getFile().replace('/', File.separatorChar);
        String lockName = String.valueOf(cfgName) + CONFIG_FILE_LOCK_SUFFIX;
        this.cfgLockFile = new File(lockName);
        if (this.cfgLockFile.exists()) {
            this.cfgLockFile.delete();
        }
        if (this.cfgLockFile.exists()) {
            throw new RuntimeException(Policy.bind("cfig.inUse", cfgName, lockName));
        }
        try {
            this.cfgLockFileRAF = new RandomAccessFile(this.cfgLockFile, LINK_READ_WRITE);
            this.cfgLockFileRAF.writeByte(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(Policy.bind("cfig.failCreateLock", cfgName));
        }
        return false;
    }

    private void clearConfigurationLock() {
        try {
            if (this.cfgLockFileRAF != null) {
                this.cfgLockFileRAF.close();
                this.cfgLockFileRAF = null;
            }
        }
        catch (IOException iOException) {}
        if (this.cfgLockFile != null) {
            this.cfgLockFile.delete();
            this.cfgLockFile = null;
        }
    }

    private boolean configurationInWorkspace(URL url) {
        return true;
    }

    private void computeChangeStamp() {
        this.computeFeaturesChangeStamp();
        this.computePluginsChangeStamp();
        this.changeStamp = this.featuresChangeStamp ^ this.pluginsChangeStamp;
        this.changeStampIsValid = true;
    }

    private void computeFeaturesChangeStamp() {
        if (this.featuresChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            result ^= sites[i].getFeaturesChangeStamp();
            ++i;
        }
        this.featuresChangeStamp = result;
        this.featuresChangeStampIsValid = true;
    }

    private void computePluginsChangeStamp() {
        if (this.pluginsChangeStampIsValid) {
            return;
        }
        long result = 0L;
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            result ^= sites[i].getPluginsChangeStamp();
            ++i;
        }
        this.pluginsChangeStamp = result;
        this.pluginsChangeStampIsValid = true;
    }

    private void configureExternalLinks() {
        URL linkURL = BootLoader.getInstallURL();
        if (!PlatformConfiguration.supportsDetection(linkURL)) {
            return;
        }
        try {
            linkURL = new URL(linkURL, "links/");
        }
        catch (MalformedURLException malformedURLException) {
            if (DEBUG) {
                PlatformConfiguration.debug("Unable to obtain link URL");
            }
            return;
        }
        File linkDir = new File(linkURL.getFile());
        File[] links = linkDir.listFiles();
        if (links == null || links.length == 0) {
            if (DEBUG) {
                PlatformConfiguration.debug("No links detected in " + linkURL.toExternalForm());
            }
            return;
        }
        int i = 0;
        while (i < links.length) {
            block22: {
                if (!links[i].isDirectory()) {
                    Object var8_8;
                    if (DEBUG) {
                        PlatformConfiguration.debug("Link file " + links[i].getAbsolutePath());
                    }
                    Properties props = new Properties();
                    FileInputStream is = null;
                    try {
                        try {
                            is = new FileInputStream(links[i]);
                            props.load(is);
                            this.configureExternalLinkSites(links[i], props);
                        }
                        catch (IOException e) {
                            if (DEBUG) {
                                PlatformConfiguration.debug("   unable to load link file " + e);
                            }
                            var8_8 = null;
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException) {}
                            }
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        var8_8 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    var8_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            ++i;
        }
    }

    private void configureExternalLinkSites(File linkFile, Properties props) {
        URL siteURL;
        String link;
        String path = props.getProperty(LINK_PATH);
        if (path == null) {
            if (DEBUG) {
                PlatformConfiguration.debug("   no path definition");
            }
            return;
        }
        boolean updateable = true;
        IPlatformConfiguration.ISitePolicy linkSitePolicy = this.createSitePolicy(1, DEFAULT_POLICY_LIST);
        if (path.startsWith("r ")) {
            updateable = false;
            link = path.substring(2).trim();
        } else {
            link = path.startsWith("rw ") ? path.substring(3).trim() : path;
        }
        try {
            File target;
            if (!link.endsWith(File.separator)) {
                link = String.valueOf(link) + File.separator;
            }
            if (!(link = "file:" + (target = new File(String.valueOf(link) + ECLIPSE)).getAbsolutePath().replace(File.separatorChar, '/')).endsWith("/")) {
                link = String.valueOf(link) + "/";
            }
            siteURL = new URL(link);
        }
        catch (MalformedURLException e) {
            if (DEBUG) {
                PlatformConfiguration.debug("  bad URL " + e);
            }
            return;
        }
        SiteEntry linkSite = (SiteEntry)this.externalLinkSites.get(siteURL);
        if (linkSite != null) {
            linkSite.updateable = updateable;
            linkSite.linkFileName = linkFile.getAbsolutePath();
        } else {
            linkSite = (SiteEntry)this.createSiteEntry(siteURL, linkSitePolicy);
            linkSite.updateable = updateable;
            linkSite.linkFileName = linkFile.getAbsolutePath();
        }
        this.configureSite(linkSite);
        if (DEBUG) {
            PlatformConfiguration.debug("   " + (updateable ? "R/W -> " : "R/O -> ") + siteURL.toString());
        }
    }

    private void updateConfigurationFromPlugins(URL file) throws IOException {
        URL[] pluginPath = BootLoader.getPluginPath(file);
        if (pluginPath == null || pluginPath.length == 0) {
            return;
        }
        PlatformConfiguration tempConfig = new PlatformConfiguration(null);
        int i = 0;
        while (i < pluginPath.length) {
            block13: {
                String pluginPortion;
                String sitePortion;
                int ix;
                block15: {
                    String entry;
                    block14: {
                        entry = pluginPath[i].toExternalForm();
                        if (!entry.endsWith("/")) break block14;
                        ix = PlatformConfiguration.findEntrySeparator(entry, 2);
                        sitePortion = entry.substring(0, ix + 1);
                        pluginPortion = entry.substring(ix + 1);
                        if (!pluginPortion.equals("plugins/")) break block13;
                        pluginPortion = null;
                        break block15;
                    }
                    ix = PlatformConfiguration.findEntrySeparator(entry, 3);
                    sitePortion = entry.substring(0, ix + 1);
                    pluginPortion = entry.substring(ix + 1);
                }
                if (ix != -1) {
                    IPlatformConfiguration.ISitePolicy policy;
                    IPlatformConfiguration.ISiteEntry site;
                    URL siteURL;
                    block12: {
                        siteURL = null;
                        try {
                            siteURL = new URL(sitePortion);
                            if (!siteURL.getProtocol().equals("file")) break block12;
                            File sf = new File(siteURL.getFile());
                            String sfn = sf.getAbsolutePath().replace(File.separatorChar, '/');
                            if (!sfn.endsWith("/")) {
                                sfn = String.valueOf(sfn) + "/";
                            }
                            siteURL = new URL("file:" + sfn);
                        }
                        catch (MalformedURLException malformedURLException) {
                            break block13;
                        }
                    }
                    if ((site = tempConfig.findConfiguredSite(siteURL)) == null) {
                        policy = pluginPortion == null ? tempConfig.createSitePolicy(1, null) : tempConfig.createSitePolicy(0, new String[]{pluginPortion});
                        site = tempConfig.createSiteEntry(siteURL, policy);
                        tempConfig.configureSite(site);
                    } else {
                        policy = site.getSitePolicy();
                        if (policy.getType() != 1) {
                            if (pluginPortion == null) {
                                policy = tempConfig.createSitePolicy(1, null);
                            } else {
                                ArrayList<String> list = new ArrayList<String>(Arrays.asList(policy.getList()));
                                list.add(pluginPortion);
                                policy = tempConfig.createSitePolicy(0, list.toArray(new String[0]));
                            }
                            site.setSitePolicy(policy);
                        }
                    }
                }
            }
            ++i;
        }
        IPlatformConfiguration.ISiteEntry[] tempSites = tempConfig.getConfiguredSites();
        int i2 = 0;
        while (i2 < tempSites.length) {
            this.configureSite(tempSites[i2], true);
            ++i2;
        }
    }

    private void validateSites() {
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        int i = 0;
        while (i < list.length) {
            File siteRoot;
            URL siteURL = list[i].getResolvedURL();
            if (PlatformConfiguration.supportsDetection(siteURL) && !(siteRoot = new File(siteURL.getFile().replace('/', File.separatorChar))).exists()) {
                this.unconfigureSite(list[i]);
                if (DEBUG) {
                    PlatformConfiguration.debug("Site " + siteURL + " does not exist ... removing from configuration");
                }
            }
            ++i;
        }
    }

    private void copyInitializedState(URL source, String target, String dir) {
        try {
            if (!source.getProtocol().equals("file")) {
                return;
            }
            this.copy(new File(source.getFile()), new File(target), dir);
        }
        catch (IOException iOException) {}
    }

    private void copy(File srcDir, File tgtDir, String extraPath) throws IOException {
        block20: {
            File tgt;
            File src;
            block19: {
                src = new File(srcDir, extraPath);
                tgt = new File(tgtDir, extraPath);
                if (!src.isDirectory()) break block19;
                tgt.mkdir();
                String[] list = src.list();
                if (list == null) {
                    return;
                }
                int i = 0;
                while (i < list.length) {
                    this.copy(srcDir, tgtDir, String.valueOf(extraPath) + File.separator + list[i]);
                    ++i;
                }
                break block20;
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                try {
                    is = new FileInputStream(src);
                    os = new FileOutputStream(tgt);
                    byte[] buff = new byte[1024];
                    int count = is.read(buff);
                    while (count != -1) {
                        os.write(buff, 0, count);
                        count = is.read(buff);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var10_14 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (os == null) break block20;
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void load(URL url) throws IOException {
        String stamp;
        if (url == null) {
            throw new IOException(Policy.bind("cfig.unableToLoad.noURL"));
        }
        Properties props = null;
        IOException originalException = null;
        try {
            props = this.loadProperties(url, null);
        }
        catch (IOException e1) {
            originalException = e1;
            try {
                props = this.loadProperties(url, CONFIG_FILE_TEMP_SUFFIX);
            }
            catch (IOException iOException) {
                try {
                    props = this.loadProperties(url, CONFIG_FILE_BAK_SUFFIX);
                }
                catch (IOException iOException2) {
                    throw originalException;
                }
            }
        }
        String v = props.getProperty("version");
        if (!VERSION.equals(v)) {
            throw new IOException(Policy.bind("cfig.badVersion", v));
        }
        this.defaultFeature = this.loadAttribute(props, "feature.default.id", null);
        String flag = this.loadAttribute(props, CFG_TRANSIENT, null);
        if (flag != null) {
            this.transientConfig = flag.equals("true");
        }
        if ((stamp = this.loadAttribute(props, CFG_STAMP, null)) != null) {
            try {
                this.lastChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, CFG_FEATURE_STAMP, null)) != null) {
            try {
                this.lastFeaturesChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, CFG_PLUGIN_STAMP, null)) != null) {
            try {
                this.lastPluginsChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            this.bootPlugins.put(ids[i], this.loadAttribute(props, "bootstrap." + ids[i], null));
            ++i;
        }
        IPlatformConfiguration.IFeatureEntry fe = this.loadFeatureEntry(props, "feature.0", null);
        int i2 = 1;
        while (fe != null) {
            this.configureFeatureEntry(fe);
            fe = this.loadFeatureEntry(props, "feature." + i2, null);
            ++i2;
        }
        SiteEntry root = (SiteEntry)this.getRootSite();
        String rootUrlString = root.getURL().toExternalForm();
        SiteEntry se = (SiteEntry)this.loadSite(props, "site.0", null);
        int i3 = 1;
        while (se != null) {
            if (cmdFirstUse && rootUrlString.equals(se.getURL().toExternalForm())) {
                se = root;
            }
            if (!se.isExternallyLinkedSite()) {
                this.configureSite(se);
            } else {
                this.externalLinkSites.put(se.getURL(), se);
            }
            se = (SiteEntry)this.loadSite(props, "site." + i3, null);
            ++i3;
        }
    }

    private Properties loadProperties(URL url, String suffix) throws IOException {
        Properties props;
        block9: {
            if (suffix != null && !suffix.equals("")) {
                url = new URL(url.getProtocol(), url.getHost(), url.getPort(), String.valueOf(url.getFile()) + suffix);
            }
            props = new Properties();
            InputStream is = null;
            try {
                is = url.openStream();
                props.load(is);
                if (!EOF.equals(props.getProperty(EOF))) {
                    throw new IOException(Policy.bind("cfig.unableToLoad.incomplete", url.toString()));
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (is == null) break block9;
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return props;
    }

    private IPlatformConfiguration.ISiteEntry loadSite(Properties props, String name, IPlatformConfiguration.ISiteEntry dflt) {
        String linkname;
        String flag;
        String[] policyList;
        int policyType;
        String urlString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_URL, null);
        if (urlString == null) {
            return dflt;
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return dflt;
        }
        String typeString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_POLICY, null);
        if (typeString == null) {
            policyType = 1;
            policyList = DEFAULT_POLICY_LIST;
        } else {
            int i = 0;
            while (i < CFG_POLICY_TYPE.length) {
                if (typeString.equals(CFG_POLICY_TYPE[i])) break;
                ++i;
            }
            if (i >= CFG_POLICY_TYPE.length) {
                policyType = 1;
                policyList = DEFAULT_POLICY_LIST;
            } else {
                policyType = i;
                policyList = this.loadListAttribute(props, String.valueOf(name) + "." + CFG_LIST, new String[0]);
            }
        }
        IPlatformConfiguration.ISitePolicy sp = this.createSitePolicy(policyType, policyList);
        SiteEntry site = (SiteEntry)this.createSiteEntry(url, sp);
        String stamp = this.loadAttribute(props, String.valueOf(name) + "." + CFG_STAMP, null);
        if (stamp != null) {
            try {
                site.lastChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_STAMP, null)) != null) {
            try {
                site.lastFeaturesChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((stamp = this.loadAttribute(props, String.valueOf(name) + "." + CFG_PLUGIN_STAMP, null)) != null) {
            try {
                site.lastPluginsChangeStamp = Long.parseLong(stamp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((flag = this.loadAttribute(props, String.valueOf(name) + "." + CFG_UPDATEABLE, null)) != null) {
            if (flag.equals("true")) {
                site.updateable = true;
            } else {
                site.updateable = false;
            }
        }
        if ((linkname = this.loadAttribute(props, String.valueOf(name) + "." + CFG_LINK_FILE, null)) != null && !linkname.equals("")) {
            site.linkFileName = linkname.replace('/', File.separatorChar);
        }
        return site;
    }

    private IPlatformConfiguration.IFeatureEntry loadFeatureEntry(Properties props, String name, IPlatformConfiguration.IFeatureEntry dflt) {
        String pluginIdentifier;
        String id = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ID, null);
        if (id == null) {
            return dflt;
        }
        String version = this.loadAttribute(props, String.valueOf(name) + "." + "version", null);
        String pluginVersion = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, null);
        if (pluginVersion == null) {
            pluginVersion = version;
        }
        if ((pluginIdentifier = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, null)) == null) {
            pluginIdentifier = id;
        }
        String application = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_APPLICATION, null);
        ArrayList<URL> rootList = new ArrayList<URL>();
        String rootString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ROOT + ".0", null);
        int i = 1;
        while (rootString != null) {
            try {
                URL rootEntry = new URL(rootString);
                rootList.add(rootEntry);
            }
            catch (MalformedURLException malformedURLException) {}
            rootString = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, null);
            ++i;
        }
        URL[] roots = rootList.toArray(new URL[0]);
        boolean primary = false;
        String flag = this.loadAttribute(props, String.valueOf(name) + "." + CFG_FEATURE_ENTRY_PRIMARY, null);
        if (flag != null && flag.equals("true")) {
            primary = true;
        }
        return this.createFeatureEntry(id, version, pluginIdentifier, pluginVersion, primary, application, roots);
    }

    private String[] loadListAttribute(Properties props, String name, String[] dflt) {
        ArrayList list = new ArrayList();
        String value = this.loadAttribute(props, String.valueOf(name) + ".0", null);
        if (value == null) {
            return dflt;
        }
        int i = 1;
        while (value != null) {
            this.loadListAttributeSegment(list, value);
            value = this.loadAttribute(props, String.valueOf(name) + "." + i, null);
            ++i;
        }
        return list.toArray(new String[0]);
    }

    private void loadListAttributeSegment(ArrayList list, String value) {
        if (value == null) {
            return;
        }
        StringTokenizer tokens = new StringTokenizer(value, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.add(token);
        }
    }

    private String loadAttribute(Properties props, String name, String dflt) {
        String prop = props.getProperty(name);
        if (prop == null) {
            return dflt;
        }
        return prop.trim();
    }

    private void loadInitializationAttributes() {
        String initId;
        URL url = BootLoader.getInstallURL();
        Properties initProps = new Properties();
        InputStream is = null;
        try {
            try {
                URL initURL = new URL(url, CONFIG_FILE_INIT);
                is = initURL.openStream();
                initProps.load(is);
                if (DEBUG) {
                    PlatformConfiguration.debug("Defaults from " + initURL.toExternalForm());
                }
            }
            catch (IOException iOException) {
                Object var5_5 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException2) {}
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        Object var5_7 = null;
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if ((initId = this.loadAttribute(initProps, "feature.default.id", null)) != null) {
            IPlatformConfiguration.IFeatureEntry fe;
            String application = this.loadAttribute(initProps, INIT_DEFAULT_FEATURE_APPLICATION, null);
            String initPluginId = this.loadAttribute(initProps, INIT_DEFAULT_PLUGIN_ID, null);
            if (initPluginId == null) {
                initPluginId = initId;
            }
            if ((fe = this.findConfiguredFeatureEntry(initId)) == null) {
                cmdFirstUse = true;
                fe = this.createFeatureEntry(initId, null, initPluginId, null, true, application, null);
            } else {
                fe = this.createFeatureEntry(initId, fe.getFeatureVersion(), fe.getFeaturePluginIdentifier(), fe.getFeaturePluginVersion(), fe.canBePrimary(), application, fe.getFeatureRootURLs());
            }
            this.configureFeatureEntry(fe);
            this.defaultFeature = initId;
            if (DEBUG) {
                PlatformConfiguration.debug("    Default primary feature: " + this.defaultFeature);
                if (application != null) {
                    PlatformConfiguration.debug("    Default application    : " + application);
                }
            }
        }
    }

    private void locateDefaultPlugins() {
        HashMap runtimeImport = this.getRuntimeImport();
        URL runtimePluginPath = this.getPluginPath(runtimeImport);
        if (runtimePluginPath == null) {
            throw new RuntimeException(Policy.bind("error.runtime"));
        }
        this.runtimeDescriptor = this.createPluginBootDescriptor(runtimePluginPath);
        HashMap xmlImport = this.getImport(runtimePluginPath, XML_PLUGIN_ID);
        URL xmlPluginPath = this.getPluginPath(xmlImport);
        if (xmlPluginPath == null) {
            throw new RuntimeException(Policy.bind("error.xerces"));
        }
        this.xmlDescriptor = this.createPluginBootDescriptor(xmlPluginPath);
    }

    private HashMap getRuntimeImport() {
        URL url;
        String path;
        File base;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.internal.boot.InternalBootLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(base = new File(path = InternalBootLoader.decode((url = clazz.getProtectionDomain().getCodeSource().getLocation()).getFile()))).isDirectory()) {
            base = base.getParentFile();
        }
        File xml = null;
        while (base != null) {
            xml = new File(base, BOOT_XML);
            if (xml.exists()) break;
            base = base.getParentFile();
        }
        if (xml == null) {
            throw new RuntimeException(Policy.bind("error.boot"));
        }
        try {
            return this.getImport(xml.toURL(), RUNTIME_PLUGIN_ID);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private HashMap getImport(URL entry, String id) {
        if (id == null) {
            return null;
        }
        final String fId = id;
        Selector importSel = new Selector(){

            public boolean select(String element) {
                return element.startsWith("import");
            }

            public boolean select(String element, HashMap attributes) {
                if (attributes == null) {
                    return false;
                }
                String plugin = (String)attributes.get("plugin");
                return fId.equals(plugin);
            }
        };
        Parser p = new Parser(entry);
        return p.getElement(importSel);
    }

    private BootDescriptor createPluginBootDescriptor(URL entry) {
        if (entry == null) {
            return null;
        }
        Selector pluginSel = new Selector(){

            public boolean select(String element) {
                return element.startsWith("plugin");
            }

            public boolean select(String element, HashMap attributes) {
                return true;
            }
        };
        final ArrayList libs = new ArrayList();
        Selector librarySel = new Selector(){

            public boolean select(String element) {
                return element.startsWith("library");
            }

            public boolean select(String element, HashMap attributes) {
                if (attributes == null) {
                    return false;
                }
                String lib = (String)attributes.get("name");
                if (lib != null) {
                    libs.add(lib);
                }
                return false;
            }
        };
        Parser p = new Parser(entry);
        String id = null;
        String version = null;
        HashMap attributes = p.getElement(pluginSel);
        if (attributes != null) {
            id = (String)attributes.get(CFG_FEATURE_ENTRY_ID);
            version = (String)attributes.get("version");
        }
        if (id == null) {
            id = "";
        }
        if (version == null) {
            version = "0.0.0";
        }
        p.getElement(librarySel);
        String[] libraries = libs.toArray(new String[0]);
        String dir = entry.getFile();
        int ix = dir.lastIndexOf("/");
        dir = dir.substring(0, ix + 1);
        URL dirURL = null;
        try {
            dirURL = new URL(entry.getProtocol(), entry.getHost(), entry.getPort(), dir);
        }
        catch (MalformedURLException malformedURLException) {}
        return new BootDescriptor(id, version, libraries, dirURL);
    }

    private URL getPluginPath(HashMap importElement) {
        VersionedIdentifier id;
        if (importElement == null) {
            return null;
        }
        String pid = (String)importElement.get("plugin");
        String version = (String)importElement.get("version");
        String match = (String)importElement.get("match");
        if (pid == null) {
            return null;
        }
        if (version == null) {
            id = new VersionedIdentifier(pid);
        } else {
            id = new VersionedIdentifier(String.valueOf(pid) + "_" + version);
            if (match == null) {
                match = "compatible";
            }
        }
        IPlatformConfiguration.ISiteEntry[] sites = this.getConfiguredSites();
        if (sites == null || sites.length == 0) {
            return null;
        }
        VersionedIdentifier savedVid = id;
        String savedEntry = null;
        URL savedURL = null;
        int j = 0;
        while (j < sites.length) {
            String[] plugins = sites[j].getPlugins();
            int i = 0;
            while (plugins != null && i < plugins.length) {
                block18: {
                    int result;
                    VersionedIdentifier vid;
                    block19: {
                        String pluginVersion;
                        int ix = PlatformConfiguration.findEntrySeparator(plugins[i], 2);
                        if (ix == -1) break block18;
                        String pluginDir = plugins[i].substring(ix + 1);
                        if ((ix = pluginDir.indexOf("/")) != -1) {
                            pluginDir = pluginDir.substring(0, ix);
                        }
                        if (pluginDir.equals("") || !(vid = new VersionedIdentifier(pluginDir)).equalIdentifiers(id)) break block18;
                        if (pluginDir.indexOf("_") != -1) break block19;
                        URL xmlURL = null;
                        try {
                            xmlURL = new URL(((SiteEntry)sites[j]).getResolvedURL(), plugins[i]);
                        }
                        catch (MalformedURLException malformedURLException) {
                            break block18;
                        }
                        final String fpid = pid;
                        Selector versionSel = new Selector(){

                            public boolean select(String element) {
                                return element.startsWith("plugin");
                            }

                            public boolean select(String element, HashMap attributes) {
                                if (attributes == null) {
                                    return false;
                                }
                                String plugin = (String)attributes.get(PlatformConfiguration.CFG_FEATURE_ENTRY_ID);
                                return fpid.equals(plugin);
                            }
                        };
                        Parser p = new Parser(xmlURL);
                        HashMap attributes = p.getElement(versionSel);
                        if (attributes == null || (pluginVersion = (String)attributes.get("version")) == null) break block18;
                        pluginDir = String.valueOf(pluginDir) + "_" + pluginVersion;
                        vid = new VersionedIdentifier(pluginDir);
                    }
                    if ((result = vid.compareVersion(savedVid)) >= 0 && !("greaterOrEqual".equals(match) ? result > 3 : ("compatible".equals(match) ? result > 2 : ("equivalent".equals(match) ? result > 1 : ("perfect".equals(match) ? result > 0 : result > 3))))) {
                        savedVid = vid;
                        savedEntry = plugins[i];
                        savedURL = ((SiteEntry)sites[j]).getResolvedURL();
                    }
                }
                ++i;
            }
            ++j;
        }
        if (savedEntry == null) {
            return null;
        }
        try {
            return new URL(savedURL, savedEntry);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private void write(PrintWriter w) {
        w.println("# " + new Date().toString());
        this.writeAttribute(w, "version", VERSION);
        if (this.transientConfig) {
            this.writeAttribute(w, CFG_TRANSIENT, "true");
        }
        w.println("");
        this.writeAttribute(w, CFG_STAMP, Long.toString(this.getChangeStamp()));
        this.writeAttribute(w, CFG_FEATURE_STAMP, Long.toString(this.getFeaturesChangeStamp()));
        this.writeAttribute(w, CFG_PLUGIN_STAMP, Long.toString(this.getPluginsChangeStamp()));
        String[] ids = this.getBootstrapPluginIdentifiers();
        int i = 0;
        while (i < ids.length) {
            String location = (String)this.bootPlugins.get(ids[i]);
            if (location != null) {
                this.writeAttribute(w, "bootstrap." + ids[i], location);
            }
            ++i;
        }
        w.println("");
        this.writeAttribute(w, "feature.default.id", this.defaultFeature);
        IPlatformConfiguration.IFeatureEntry[] feats = this.getConfiguredFeatureEntries();
        int i2 = 0;
        while (i2 < feats.length) {
            this.writeFeatureEntry(w, "feature." + Integer.toString(i2), feats[i2]);
            ++i2;
        }
        SiteEntry[] list = this.sites.values().toArray(new SiteEntry[0]);
        int i3 = 0;
        while (i3 < list.length) {
            this.writeSite(w, "site." + Integer.toString(i3), list[i3]);
            ++i3;
        }
        this.writeAttribute(w, EOF, EOF);
    }

    private void writeSite(PrintWriter w, String id, SiteEntry entry) {
        w.println("");
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_URL, entry.getURL().toString());
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_STAMP, Long.toString(entry.getChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_STAMP, Long.toString(entry.getFeaturesChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_PLUGIN_STAMP, Long.toString(entry.getPluginsChangeStamp()));
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_UPDATEABLE, entry.updateable ? "true" : "false");
        if (entry.linkFileName != null && !entry.linkFileName.trim().equals("")) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_LINK_FILE, entry.linkFileName.trim().replace(File.separatorChar, '/'));
        }
        int type = entry.getSitePolicy().getType();
        String typeString = CFG_POLICY_TYPE_UNKNOWN;
        try {
            typeString = CFG_POLICY_TYPE[type];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_POLICY, typeString);
        this.writeListAttribute(w, String.valueOf(id) + "." + CFG_LIST, entry.getSitePolicy().getList());
    }

    private void writeFeatureEntry(PrintWriter w, String id, IPlatformConfiguration.IFeatureEntry entry) {
        w.println("");
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_ID, entry.getFeatureIdentifier());
        if (entry.canBePrimary()) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PRIMARY, "true");
        }
        this.writeAttribute(w, String.valueOf(id) + "." + "version", entry.getFeatureVersion());
        if (entry.getFeatureVersion() != null && !entry.getFeatureVersion().equals(entry.getFeaturePluginVersion())) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PLUGIN_VERSION, entry.getFeaturePluginVersion());
        }
        if (entry.getFeatureIdentifier() != null && !entry.getFeatureIdentifier().equals(entry.getFeaturePluginIdentifier())) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_PLUGIN_IDENTIFIER, entry.getFeaturePluginIdentifier());
        }
        this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_APPLICATION, entry.getFeatureApplication());
        URL[] roots = entry.getFeatureRootURLs();
        int i = 0;
        while (i < roots.length) {
            this.writeAttribute(w, String.valueOf(id) + "." + CFG_FEATURE_ENTRY_ROOT + "." + i, roots[i].toExternalForm());
            ++i;
        }
    }

    private void writeListAttribute(PrintWriter w, String id, String[] list) {
        if (list == null || list.length == 0) {
            return;
        }
        String value = "";
        int listLen = 0;
        int listIndex = 0;
        int i = 0;
        while (i < list.length) {
            value = listLen != 0 ? String.valueOf(value) + "," : "";
            value = String.valueOf(value) + list[i];
            if (++listLen >= 10) {
                this.writeAttribute(w, String.valueOf(id) + "." + Integer.toString(listIndex++), value);
                listLen = 0;
            }
            ++i;
        }
        if (listLen != 0) {
            this.writeAttribute(w, String.valueOf(id) + "." + Integer.toString(listIndex), value);
        }
    }

    private void writeAttribute(PrintWriter w, String id, String value) {
        if (value == null || value.trim().equals("")) {
            return;
        }
        w.println(String.valueOf(id) + "=" + this.escapedValue(value));
    }

    private String escapedValue(String value) {
        StringBuffer buf = new StringBuffer(value.length() * 2);
        int i = 0;
        while (i < value.length()) {
            char character = value.charAt(i);
            if (character == '\\' || character == '\t' || character == '\r' || character == '\n' || character == '\f') {
                buf.append('\\');
                buf.append(character);
            } else if (character < ' ' || character > '~') {
                buf.append('\\');
                buf.append('u');
                buf.append(HEX[character >> 12 & 0xF]);
                buf.append(HEX[character >> 8 & 0xF]);
                buf.append(HEX[character >> 4 & 0xF]);
                buf.append(HEX[character & 0xF]);
            } else {
                buf.append(character);
            }
            ++i;
        }
        return buf.toString();
    }

    private static String[] checkForFeatureChanges(String[] args, PlatformConfiguration cfg) {
        String actual;
        String original = cfg.getApplicationIdentifierInternal();
        if (original.equals(actual = cfg.getApplicationIdentifier())) {
            return args;
        }
        int newArgCnt = cmdFirstUse ? 3 : 2;
        String[] newArgs = new String[args.length + newArgCnt];
        newArgs[0] = CMD_APPLICATION;
        newArgs[1] = original;
        if (cmdFirstUse) {
            newArgs[2] = CMD_FIRSTUSE;
        }
        System.arraycopy(args, 0, newArgs, newArgCnt, args.length);
        if (DEBUG) {
            PlatformConfiguration.debug("triggering reconciliation ...");
        }
        return newArgs;
    }

    private static String[] checkForNewUpdates(IPlatformConfiguration cfg, String[] args) {
        try {
            URL markerURL = new URL(cfg.getConfigurationLocation(), CHANGES_MARKER);
            File marker = new File(markerURL.getFile());
            if (!marker.exists()) {
                return args;
            }
            marker.delete();
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = CMD_NEW_UPDATES;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            return newArgs;
        }
        catch (MalformedURLException malformedURLException) {
            return args;
        }
    }

    private static String[] processCommandLine(String[] args) throws Exception {
        int[] configArgs = new int[100];
        configArgs[0] = -1;
        int configArgIndex = 0;
        int i = 0;
        while (i < args.length) {
            boolean found = false;
            if (args[i].equalsIgnoreCase(CMD_FIRSTUSE)) {
                cmdFirstUse = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_UPDATE)) {
                cmdUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_NO_UPDATE)) {
                cmdNoUpdate = true;
                found = true;
            }
            if (args[i].equalsIgnoreCase(CMD_INITIALIZE)) {
                cmdInitialize = true;
            } else if (args[i].equalsIgnoreCase(CMD_DEV)) {
                cmdDev = true;
            } else if (found) {
                configArgs[configArgIndex++] = i;
            } else if (i != args.length - 1 && !args[i + 1].startsWith("-")) {
                String arg = args[++i];
                if (args[i - 1].equalsIgnoreCase(CMD_CONFIGURATION)) {
                    found = true;
                    cmdConfiguration = arg;
                }
                if (args[i - 1].equalsIgnoreCase(CMD_FEATURE)) {
                    found = true;
                    cmdFeature = arg;
                }
                if (args[i - 1].equalsIgnoreCase(CMD_APPLICATION)) {
                    found = true;
                    if (cmdApplication == null) {
                        cmdApplication = arg;
                    }
                }
                if (args[i - 1].equalsIgnoreCase(CMD_PLUGINS)) {
                    found = true;
                    try {
                        if (cmdPlugins == null) {
                            cmdPlugins = new URL(arg);
                        }
                    }
                    catch (MalformedURLException e) {
                        try {
                            cmdPlugins = new URL("file:" + arg.replace(File.separatorChar, '/'));
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw e;
                        }
                    }
                }
                if (found) {
                    configArgs[configArgIndex++] = i - 1;
                    configArgs[configArgIndex++] = i;
                }
            }
            ++i;
        }
        if (configArgIndex == 0) {
            return args;
        }
        String[] passThruArgs = new String[args.length - configArgIndex];
        configArgIndex = 0;
        int j = 0;
        int i2 = 0;
        while (i2 < args.length) {
            if (i2 == configArgs[configArgIndex]) {
                ++configArgIndex;
            } else {
                passThruArgs[j++] = args[i2];
            }
            ++i2;
        }
        return passThruArgs;
    }

    private static int findEntrySeparator(String pathEntry, int cnt) {
        int i = pathEntry.length() - 1;
        while (i >= 0) {
            if (pathEntry.charAt(i) == '/' && --cnt == 0) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private static String[] stringListToArray(String prop, String separator) {
        if (prop == null || prop.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(prop, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.add(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[0]);
    }

    private static boolean supportsDetection(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            return true;
        }
        if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
            }
            catch (IOException iOException) {
                return false;
            }
            return resolved.getProtocol().equals("file");
        }
        return false;
    }

    private static void verifyPath(URL url) {
        File dir;
        String protocol = url.getProtocol();
        String path = null;
        if (protocol.equals("file")) {
            path = url.getFile();
        } else if (protocol.equals("platform")) {
            URL resolved = null;
            try {
                resolved = PlatformConfiguration.resolvePlatformURL(url);
                if (resolved.getProtocol().equals("file")) {
                    path = resolved.getFile();
                }
            }
            catch (IOException iOException) {}
        }
        if (path != null && (dir = new File(path).getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    private static URL resolvePlatformURL(URL url) throws IOException {
        if (url.getProtocol().equals("platform")) {
            URLConnection connection = url.openConnection();
            url = connection instanceof PlatformURLConnection ? ((PlatformURLConnection)connection).getResolvedURL() : InternalBootLoader.getInstallURL();
        }
        return url;
    }

    private static void debug(String s) {
        System.out.println("PlatformConfig: " + s);
    }

    public class SiteEntry
    implements IPlatformConfiguration.ISiteEntry {
        private URL url;
        private URL resolvedURL;
        private IPlatformConfiguration.ISitePolicy policy;
        private boolean updateable = true;
        private ArrayList features;
        private ArrayList plugins;
        private PlatformConfiguration parent;
        private long lastChangeStamp;
        private long changeStamp;
        private boolean changeStampIsValid = false;
        private long lastFeaturesChangeStamp;
        private long featuresChangeStamp;
        private boolean featuresChangeStampIsValid = false;
        private long lastPluginsChangeStamp;
        private long pluginsChangeStamp;
        private boolean pluginsChangeStampIsValid = false;
        private String linkFileName = null;

        private SiteEntry() {
        }

        private SiteEntry(URL url, IPlatformConfiguration.ISitePolicy policy, PlatformConfiguration parent) {
            if (url == null) {
                throw new IllegalArgumentException();
            }
            if (policy == null) {
                throw new IllegalArgumentException();
            }
            if (parent == null) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.policy = policy;
            this.parent = parent;
            this.features = null;
            this.plugins = null;
            this.resolvedURL = this.url;
            if (url.getProtocol().equals("platform")) {
                try {
                    this.resolvedURL = PlatformConfiguration.resolvePlatformURL(url);
                }
                catch (IOException iOException) {}
            }
        }

        public URL getURL() {
            return this.url;
        }

        public IPlatformConfiguration.ISitePolicy getSitePolicy() {
            return this.policy;
        }

        public synchronized void setSitePolicy(IPlatformConfiguration.ISitePolicy policy) {
            if (policy == null) {
                throw new IllegalArgumentException();
            }
            this.policy = policy;
        }

        public String[] getFeatures() {
            return this.getDetectedFeatures();
        }

        public String[] getPlugins() {
            IPlatformConfiguration.ISitePolicy policy = this.getSitePolicy();
            if (policy.getType() == 0) {
                return policy.getList();
            }
            if (policy.getType() == 1) {
                ArrayList<String> detectedPlugins = new ArrayList<String>(Arrays.asList(this.getDetectedPlugins()));
                String[] excludedPlugins = policy.getList();
                int i = 0;
                while (i < excludedPlugins.length) {
                    if (detectedPlugins.contains(excludedPlugins[i])) {
                        ((AbstractCollection)detectedPlugins).remove(excludedPlugins[i]);
                    }
                    ++i;
                }
                return detectedPlugins.toArray(new String[0]);
            }
            return new String[0];
        }

        public long getChangeStamp() {
            if (!this.changeStampIsValid) {
                this.computeChangeStamp();
            }
            return this.changeStamp;
        }

        public long getFeaturesChangeStamp() {
            if (!this.featuresChangeStampIsValid) {
                this.computeFeaturesChangeStamp();
            }
            return this.featuresChangeStamp;
        }

        public long getPluginsChangeStamp() {
            if (!this.pluginsChangeStampIsValid) {
                this.computePluginsChangeStamp();
            }
            return this.pluginsChangeStamp;
        }

        public boolean isUpdateable() {
            return this.updateable;
        }

        public boolean isNativelyLinked() {
            return this.isExternallyLinkedSite();
        }

        private String[] detectFeatures() {
            this.changeStampIsValid = false;
            this.featuresChangeStampIsValid = false;
            this.parent.changeStampIsValid = false;
            this.parent.featuresChangeStampIsValid = false;
            this.features = new ArrayList();
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                return new String[0];
            }
            File siteRoot = new File(this.resolvedURL.getFile().replace('/', File.separatorChar));
            File root = new File(siteRoot, PlatformConfiguration.FEATURES);
            String[] list = root.list();
            int i = 0;
            while (list != null && i < list.length) {
                String path = String.valueOf(list[i]) + File.separator + PlatformConfiguration.FEATURE_XML;
                File plugin = new File(root, path);
                if (plugin.exists()) {
                    this.features.add("features/" + path.replace(File.separatorChar, '/'));
                }
                ++i;
            }
            if (DEBUG) {
                PlatformConfiguration.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.features.size() + " feature(s)");
            }
            return this.features.toArray(new String[0]);
        }

        private String[] detectPlugins() {
            this.changeStampIsValid = false;
            this.pluginsChangeStampIsValid = false;
            this.parent.changeStampIsValid = false;
            this.parent.pluginsChangeStampIsValid = false;
            this.plugins = new ArrayList();
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                return new String[0];
            }
            File root = new File(String.valueOf(this.resolvedURL.getFile().replace('/', File.separatorChar)) + PlatformConfiguration.PLUGINS);
            String[] list = root.list();
            int i = 0;
            while (list != null && i < list.length) {
                String path = String.valueOf(list[i]) + File.separator + PlatformConfiguration.PLUGIN_XML;
                File plugin = new File(root, path);
                if (plugin.exists() || (plugin = new File(root, path = String.valueOf(list[i]) + File.separator + PlatformConfiguration.FRAGMENT_XML)).exists()) {
                    this.plugins.add("plugins/" + path.replace(File.separatorChar, '/'));
                }
                ++i;
            }
            if (DEBUG) {
                PlatformConfiguration.debug(String.valueOf(this.resolvedURL.toString()) + " located  " + this.plugins.size() + " plugin(s)");
            }
            return this.plugins.toArray(new String[0]);
        }

        private synchronized String[] getDetectedFeatures() {
            if (this.features == null) {
                return this.detectFeatures();
            }
            return this.features.toArray(new String[0]);
        }

        private synchronized String[] getDetectedPlugins() {
            if (this.plugins == null) {
                return this.detectPlugins();
            }
            return this.plugins.toArray(new String[0]);
        }

        private URL getResolvedURL() {
            return this.resolvedURL;
        }

        private void computeChangeStamp() {
            this.computeFeaturesChangeStamp();
            this.computePluginsChangeStamp();
            this.changeStamp = (long)this.resolvedURL.hashCode() ^ this.featuresChangeStamp ^ this.pluginsChangeStamp;
            this.changeStampIsValid = true;
        }

        private synchronized void computeFeaturesChangeStamp() {
            if (this.featuresChangeStampIsValid) {
                return;
            }
            long start = 0L;
            if (DEBUG) {
                start = new Date().getTime();
            }
            String[] features = this.getFeatures();
            this.featuresChangeStamp = this.computeStamp(features);
            this.featuresChangeStampIsValid = true;
            if (DEBUG) {
                long end = new Date().getTime();
                PlatformConfiguration.debug(String.valueOf(this.resolvedURL.toString()) + " feature stamp: " + this.featuresChangeStamp + (this.featuresChangeStamp == this.lastFeaturesChangeStamp ? " [no changes]" : " [was " + this.lastFeaturesChangeStamp + "]") + " in " + (end - start) + "ms");
            }
        }

        private synchronized void computePluginsChangeStamp() {
            if (this.pluginsChangeStampIsValid) {
                return;
            }
            long start = 0L;
            if (DEBUG) {
                start = new Date().getTime();
            }
            String[] plugins = this.getPlugins();
            this.pluginsChangeStamp = this.computeStamp(plugins);
            this.pluginsChangeStampIsValid = true;
            if (DEBUG) {
                long end = new Date().getTime();
                PlatformConfiguration.debug(String.valueOf(this.resolvedURL.toString()) + " plugin stamp: " + this.pluginsChangeStamp + (this.pluginsChangeStamp == this.lastPluginsChangeStamp ? " [no changes]" : " [was " + this.lastPluginsChangeStamp + "]") + " in " + (end - start) + "ms");
            }
        }

        private long computeStamp(String[] targets) {
            long result = 0L;
            if (!PlatformConfiguration.supportsDetection(this.resolvedURL)) {
                int i = 0;
                while (i < targets.length) {
                    result ^= (long)targets[i].hashCode();
                    ++i;
                }
                if (DEBUG) {
                    PlatformConfiguration.debug("*WARNING* computing stamp using URL hashcodes only");
                }
            } else {
                File rootFile;
                String rootPath = this.resolvedURL.getFile().replace('/', File.separatorChar);
                if (!rootPath.endsWith(File.separator)) {
                    rootPath = String.valueOf(rootPath) + File.separator;
                }
                if ((rootFile = new File(rootPath)).exists()) {
                    File f = null;
                    int i = 0;
                    while (i < targets.length) {
                        f = new File(rootFile, targets[i]);
                        if (f.exists()) {
                            result ^= (long)f.getAbsolutePath().hashCode() ^ f.lastModified() ^ f.length();
                        }
                        ++i;
                    }
                }
            }
            return result;
        }

        private boolean isExternallyLinkedSite() {
            return this.linkFileName != null && !this.linkFileName.trim().equals("");
        }

        private synchronized void refresh() {
            this.lastChangeStamp = this.changeStamp;
            this.lastFeaturesChangeStamp = this.featuresChangeStamp;
            this.lastPluginsChangeStamp = this.pluginsChangeStamp;
            this.changeStampIsValid = false;
            this.featuresChangeStampIsValid = false;
            this.pluginsChangeStampIsValid = false;
            this.features = null;
            this.plugins = null;
        }
    }

    public class SitePolicy
    implements IPlatformConfiguration.ISitePolicy {
        private int type;
        private String[] list;

        private SitePolicy() {
        }

        private SitePolicy(int type, String[] list) {
            if (type != 0 && type != 1) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.list = list == null ? new String[0] : list;
        }

        public int getType() {
            return this.type;
        }

        public String[] getList() {
            return this.list;
        }

        public synchronized void setList(String[] list) {
            this.list = list == null ? new String[0] : list;
        }
    }

    private class FeatureEntry
    implements IPlatformConfiguration.IFeatureEntry {
        private String id;
        private String version;
        private String pluginVersion;
        private String application;
        private URL[] root;
        private boolean primary;
        private String pluginIdentifier;

        FeatureEntry(String id, String version, String pluginIdentifier, String pluginVersion, boolean primary, String application, URL[] root) {
            if (id == null) {
                throw new IllegalArgumentException();
            }
            this.id = id;
            this.version = version;
            this.pluginVersion = pluginVersion;
            this.pluginIdentifier = pluginIdentifier;
            this.primary = primary;
            this.application = application;
            this.root = root == null ? new URL[]{} : root;
        }

        FeatureEntry(String id, String version, String pluginVersion, boolean primary, String application, URL[] root) {
            this(id, version, id, pluginVersion, primary, application, root);
        }

        public String getFeatureIdentifier() {
            return this.id;
        }

        public String getFeatureVersion() {
            return this.version;
        }

        public String getFeaturePluginVersion() {
            return this.pluginVersion;
        }

        public String getFeatureApplication() {
            return this.application;
        }

        public URL[] getFeatureRootURLs() {
            return this.root;
        }

        public boolean canBePrimary() {
            return this.primary;
        }

        public String getFeaturePluginIdentifier() {
            return this.pluginIdentifier;
        }
    }

    private class VersionedIdentifier {
        private String identifier = "";
        private int major = 0;
        private int minor = 0;
        private int service = 0;
        private String qualifier = "";
        private static final String VER_SEPARATOR = ".";
        private static final String ID_SEPARATOR = "_";
        public static final int LESS_THAN = -1;
        public static final int EQUAL = 0;
        public static final int EQUIVALENT = 1;
        public static final int COMPATIBLE = 2;
        public static final int GREATER_THAN = 3;

        public VersionedIdentifier(String s) {
            if (s == null || (s = s.trim()).equals("")) {
                return;
            }
            int loc = s.lastIndexOf(ID_SEPARATOR);
            if (loc != -1) {
                this.identifier = s.substring(0, loc);
                String version = s.substring(loc + 1);
                this.parseVersion(version);
            } else {
                this.identifier = s;
            }
        }

        public boolean equalIdentifiers(VersionedIdentifier id) {
            if (id == null) {
                return this.identifier == null;
            }
            return id.identifier.equals(this.identifier);
        }

        public int compareVersion(VersionedIdentifier id) {
            if (id == null) {
                if (this.major == 0 && this.minor == 0 && this.service == 0) {
                    return -1;
                }
                return 1;
            }
            if (this.major > id.major) {
                return 3;
            }
            if (this.major < id.major) {
                return -1;
            }
            if (this.minor > id.minor) {
                return 2;
            }
            if (this.minor < id.minor) {
                return -1;
            }
            if (this.service > id.service) {
                return 1;
            }
            if (this.service < id.service) {
                return -1;
            }
            return this.compareQualifiers(this.qualifier, id.qualifier);
        }

        private int compareQualifiers(String q1, String q2) {
            int result = q1.compareTo(q2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }

        private void parseVersion(String v) {
            if (v == null || (v = v.trim()).equals("")) {
                return;
            }
            try {
                StringTokenizer st = new StringTokenizer(v, VER_SEPARATOR);
                ArrayList<String> elements = new ArrayList<String>(4);
                while (st.hasMoreTokens()) {
                    elements.add(st.nextToken());
                }
                if (elements.size() >= 1) {
                    this.major = new Integer((String)elements.get(0));
                }
                if (elements.size() >= 2) {
                    this.minor = new Integer((String)elements.get(1));
                }
                if (elements.size() >= 3) {
                    this.service = new Integer((String)elements.get(2));
                }
                if (elements.size() >= 4) {
                    this.qualifier = this.removeWhiteSpace((String)elements.get(3));
                }
            }
            catch (Exception exception) {}
        }

        private String removeWhiteSpace(String s) {
            char[] chars = s.trim().toCharArray();
            boolean whitespace = false;
            int i = 0;
            while (i < chars.length) {
                if (Character.isWhitespace(chars[i])) {
                    chars[i] = 95;
                    whitespace = true;
                }
                ++i;
            }
            return whitespace ? new String(chars) : s;
        }
    }

    public interface Selector {
        public boolean select(String var1);

        public boolean select(String var1, HashMap var2);
    }

    public static class Parser {
        private ArrayList elements = new ArrayList();

        public Parser(File file) {
            try {
                this.load(new FileInputStream(file));
            }
            catch (Exception exception) {}
        }

        public Parser(URL url) {
            try {
                this.load(url.openStream());
            }
            catch (Exception exception) {}
        }

        public HashMap getElement(Selector selector) {
            if (selector == null) {
                return null;
            }
            int i = 0;
            while (i < this.elements.size()) {
                String element = (String)this.elements.get(i);
                if (selector.select(element)) {
                    String elementName;
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    int j = 0;
                    while (j < element.length()) {
                        if (Character.isWhitespace(element.charAt(j))) break;
                        ++j;
                    }
                    if (j >= element.length()) {
                        elementName = element;
                    } else {
                        elementName = element.substring(0, j);
                        element = element.substring(j);
                        StringTokenizer t = new StringTokenizer(element, "=\"");
                        boolean isKey = true;
                        String key = "";
                        while (t.hasMoreTokens()) {
                            String token = t.nextToken().trim();
                            if (token.equals("")) continue;
                            if (isKey) {
                                key = token;
                                isKey = false;
                                continue;
                            }
                            attributes.put(key, token);
                            isKey = true;
                        }
                    }
                    if (selector.select(elementName, attributes)) {
                        attributes.put("<element>", elementName);
                        return attributes;
                    }
                }
                ++i;
            }
            return null;
        }

        private void load(InputStream is) {
            if (is == null) {
                return;
            }
            StringBuffer xml = new StringBuffer(4096);
            char[] iobuf = new char[4096];
            InputStreamReader r = null;
            try {
                try {
                    r = new InputStreamReader(is);
                    int len = r.read(iobuf, 0, iobuf.length);
                    while (len != -1) {
                        xml.append(iobuf, 0, len);
                        len = r.read(iobuf, 0, iobuf.length);
                    }
                }
                catch (Exception exception) {
                    Object var6_7 = null;
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_9 = null;
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
            String xmlString = xml.toString();
            StringTokenizer t = new StringTokenizer(xmlString, "<>");
            while (t.hasMoreTokens()) {
                String token = t.nextToken().trim();
                if (token.equals("")) continue;
                this.elements.add(token);
            }
        }
    }

    public static class BootDescriptor {
        private String id;
        private String version;
        private String[] libs;
        private URL dir;

        public BootDescriptor(String id, String version, String[] libs, URL dir) {
            this.id = id;
            this.version = version;
            this.libs = libs;
            this.dir = dir;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public String[] getLibraries() {
            return this.libs;
        }

        public URL getPluginDirectoryURL() {
            return this.dir;
        }
    }
}

