/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageRegistry {
    private Map table = new HashMap(10);

    public ImageRegistry() {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public ImageRegistry(Display display) {
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public Image get(String key) {
        Object entry = this.table.get(key);
        if (entry == null) {
            return null;
        }
        if (entry instanceof Image) {
            return (Image)entry;
        }
        Image image = ((ImageDescriptor)entry).createImage();
        this.table.put(key, image);
        return image;
    }

    private void handleDisplayDispose() {
        Iterator e = this.table.values().iterator();
        while (e.hasNext()) {
            Object next = e.next();
            if (!(next instanceof Image)) continue;
            ((Image)next).dispose();
        }
        this.table = null;
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ImageRegistry.this.handleDisplayDispose();
            }
        });
    }

    public void put(String key, ImageDescriptor descriptor) {
        Object entry = this.table.get(key);
        if (entry == null || entry instanceof ImageDescriptor) {
            this.table.put(key, descriptor);
            return;
        }
        throw new IllegalArgumentException("ImageRegistry key already in use: " + key);
    }

    public void put(String key, Image image) {
        Object entry = this.table.get(key);
        if (entry == null || entry instanceof ImageDescriptor) {
            this.table.put(key, image);
            return;
        }
        throw new IllegalArgumentException("ImageRegistry key already in use: " + key);
    }
}

