/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.PluginRegistry;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ExtensionModel;

public class Extension
extends ExtensionModel
implements IExtension {
    private int subElementsCacheOffset;
    private boolean fullyLoaded = true;

    public IConfigurationElement[] getConfigurationElements() {
        ConfigurationElementModel[] list = this.getSubElements();
        if (list == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] newValues = new IConfigurationElement[list.length];
        System.arraycopy(list, 0, newValues, 0, list.length);
        return newValues;
    }

    public IPluginDescriptor getDeclaringPluginDescriptor() {
        return (IPluginDescriptor)((Object)this.getParentPluginDescriptor());
    }

    public String getExtensionPointUniqueIdentifier() {
        return this.getExtensionPoint();
    }

    public String getLabel() {
        String s = this.getName();
        return s == null ? "" : ((PluginDescriptor)this.getDeclaringPluginDescriptor()).getResourceString(s);
    }

    public String getSimpleIdentifier() {
        return this.getId();
    }

    public String getUniqueIdentifier() {
        String simple = this.getSimpleIdentifier();
        if (simple == null) {
            return null;
        }
        return String.valueOf(this.getParentPluginDescriptor().getId()) + "." + simple;
    }

    public String toString() {
        return String.valueOf(this.getParent().getPluginId()) + "." + this.getSimpleIdentifier();
    }

    int getSubElementsCacheOffset() {
        return this.subElementsCacheOffset;
    }

    void setSubElementsCacheOffset(int subElementsCacheOffset) {
        this.subElementsCacheOffset = subElementsCacheOffset;
    }

    public boolean isFullyLoaded() {
        return this.fullyLoaded;
    }

    public void setFullyLoaded(boolean fullyLoaded) {
        this.fullyLoaded = fullyLoaded;
    }

    public ConfigurationElementModel[] getSubElements() {
        if (!this.fullyLoaded) {
            ((PluginRegistry)this.getParent().getRegistry()).loadConfigurationElements(this);
        }
        return super.getSubElements();
    }

    protected void assertIsWriteable() {
        if (this.fullyLoaded) {
            super.assertIsWriteable();
        }
    }
}

