/*
 * Decompiled with CFR 0.152.
 */
package edu.amherst.acdc.orchard;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.fcrepo.kernel.api.identifiers.InternalIdentifierConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleTreeConverter
extends InternalIdentifierConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppleTreeConverter.class);
    private int segments;
    private int length;

    public AppleTreeConverter(int segments, int length) {
        this.segments = segments;
        this.length = length;
    }

    public AppleTreeConverter() {
        this(4, 2);
    }

    protected String doForward(String externalId) {
        if (externalId.startsWith("/")) {
            return "/" + this.expandTree(externalId.substring(1));
        }
        return this.expandTree(externalId);
    }

    protected String doBackward(String internalId) {
        if (internalId.startsWith("/")) {
            return "/" + this.collapseTree(internalId.substring(1));
        }
        return this.collapseTree(internalId);
    }

    private String expandTree(String externalId) {
        String internalId = Arrays.stream(externalId.split("/")).map(this::buildTreeFromId).collect(Collectors.joining("/"));
        LOGGER.debug("Converting {} to {}", (Object)externalId, (Object)internalId);
        return internalId;
    }

    private String collapseTree(String internalId) {
        String externalId = Lists.partition(Arrays.asList(internalId.split("/")), (int)(this.segments + 1)).stream().map(list -> {
            String last = (String)list.get(list.size() - 1);
            String joined = String.join((CharSequence)"/", list);
            if (joined.equals(this.buildTreeFromId(last))) {
                return last;
            }
            return joined;
        }).collect(Collectors.joining("/"));
        LOGGER.debug("Converting {} to {}", (Object)internalId, (Object)externalId);
        return externalId;
    }

    private String buildTreeFromId(String id) {
        if (id.isEmpty()) {
            return id;
        }
        return String.join((CharSequence)"/", Splitter.fixedLength((int)this.length).limit(this.segments + 1).splitToList((CharSequence)DigestUtils.md5Hex((String)id.split("#")[0])).subList(0, this.segments).stream().collect(Collectors.joining("/")), id);
    }
}

