/*
 * Decompiled with CFR 0.152.
 */
package edu.byu.hbll.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.yaml.snakeyaml.Yaml;

public class YamlLoader {
    private ObjectMapper objectMapper = new ObjectMapper();
    private Yaml yaml = new Yaml();

    public JsonNode load(Reader ... readers) throws JsonProcessingException, IOException {
        return this.load(null, Paths.get("", new String[0]), readers);
    }

    public <T> T load(Class<T> targetType, Reader ... readers) throws JsonProcessingException, IOException {
        return (T)this.objectMapper.treeToValue((TreeNode)this.load(readers), targetType);
    }

    public JsonNode load(Path ... paths) throws JsonProcessingException, IOException {
        JsonNode mainNode = null;
        for (Path path : paths) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                mainNode = this.load(mainNode, path.getParent(), reader);
            }
        }
        return mainNode;
    }

    public <T> T load(Class<T> targetType, Path ... paths) throws JsonProcessingException, IOException {
        return (T)this.objectMapper.treeToValue((TreeNode)this.load(paths), targetType);
    }

    private JsonNode load(JsonNode mainNode, Path directory, Reader ... readers) throws JsonProcessingException, IOException {
        for (Reader reader : readers) {
            JsonNode thisNode = this.objectMapper.valueToTree(this.yaml.load(reader));
            for (JsonNode importField : thisNode.path("@import")) {
                JsonNode updateNode = this.load(directory.resolve(importField.asText()));
                mainNode = this.merge(mainNode, updateNode);
            }
            mainNode = this.merge(mainNode, thisNode);
        }
        return mainNode;
    }

    JsonNode merge(JsonNode mainNode, JsonNode updateNode) {
        if (mainNode == null || !mainNode.isObject() || !updateNode.isObject()) {
            return updateNode;
        }
        Iterator fieldNames = updateNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode currentMainNode = mainNode.path(fieldName);
            JsonNode currentUpdateNode = updateNode.path(fieldName);
            if (currentMainNode.isObject() && currentUpdateNode.isObject()) {
                this.merge(currentMainNode, currentUpdateNode);
                continue;
            }
            if (!mainNode.isObject()) continue;
            ((ObjectNode)mainNode).replace(fieldName, currentUpdateNode);
        }
        return mainNode;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

