package edu.byu.hbll.solr;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;

/**
 * Utility class for initializing a Solr collection.
 *
 * @deprecated since 1.2.0; use {@link SolrCollectionInitializer} instead.
 */
@Deprecated
public class CollectionInitializer {

  /**
   * Creates a SolrCloud collection if it doesn't already exist with the given config set.
   *
   * @param zkHost host and optional port of one of a zookeeper instance (localhost:2181)
   * @param collectionName name of the collection to be created
   * @param configSetName name of the config set to use
   * @param configSetPath location of the config set (folder containing solr configs such as
   *     solrconfig.xml)
   * @throws IOException if something goes wrong with the upload
   * @throws SolrServerException if something goes wrong with the upload
   * @deprecated since 1.2.0; use {@link SolrCollectionInitializer} instead.
   */
  @Deprecated
  public static void initSolr(
      String zkHost, String collectionName, String configSetName, Path configSetPath)
      throws IOException, SolrServerException {
    try (ZkClientClusterStateProvider provider = new ZkClientClusterStateProvider(zkHost)) {
      provider.uploadConfig(configSetPath, configSetName);
    }

    try (SolrClient solr = new CloudSolrClient.Builder().withZkHost(zkHost).build()) {
      List<String> existingCollectionNames = CollectionAdminRequest.listCollections(solr);

      if (!existingCollectionNames.contains(collectionName)) {
        solr.request(CollectionAdminRequest.createCollection(collectionName, configSetName, 1, 1));
      }
    }
  }

  /**
   * Method to initialize a Solr collection using the provided default configs.
   *
   * @param zkHost host and optional port of one of a zookeeper instance (localhost:2181)
   * @param collectionName name of the collection to be created
   * @throws IOException if something goes wrong with the upload
   * @throws SolrServerException if something goes wrong with the upload
   * @deprecated since 1.2.0; use {@link SolrCollectionInitializer} instead.
   */
  @Deprecated
  public static void initSolr(String zkHost, String collectionName)
      throws IOException, SolrServerException {
    try (SolrClient solr = new CloudSolrClient.Builder().withZkHost(zkHost).build()) {
      List<String> existingCollectionNames = CollectionAdminRequest.listCollections(solr);
      if (!existingCollectionNames.contains(collectionName)) {
        solr.request(CollectionAdminRequest.createCollection(collectionName, 1, 1));
      }
    }
  }
}
