package edu.byu.hbll.solr;

import java.io.IOException;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.params.CommonParams;
import org.apache.solr.common.util.NamedList;

/**
 * A {@link SolrClient} that uses an underlying {@link SolrClient} instance that sets a default
 * collection.
 */
@Getter
@AllArgsConstructor
public class CollectionSolrClient extends SolrClient {

  /** The underlying Solr client. */
  private SolrClient client;

  /** The default collection to use for all requests. */
  private String defaultCollection;

  @Override
  public void close() throws IOException {
    client.close();
  }

  @Override
  public NamedList<Object> request(
      @SuppressWarnings({"rawtypes"}) SolrRequest request, String collection)
      throws SolrServerException, IOException {
    String requestCollection = request.getCollection();

    if (requestCollection != null) {
      collection = requestCollection;
    } else if (collection == null) {
      collection = defaultCollection;
    }

    if (CommonParams.ADMIN_PATHS.contains(request.getPath())) {
      // don't include the collection when calling admin APIs
      return client.request(request, null);
    } else {
      return client.request(request, collection);
    }
  }
}
