package edu.byu.hbll.solr.auto;

import edu.byu.hbll.solr.SolrCollectionInitializer;
import java.nio.file.Path;
import java.util.List;
import lombok.Getter;
import lombok.Setter;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.springframework.boot.context.properties.ConfigurationProperties;

/** Properties for the auto configuration of the {@link CloudSolrClient}. */
@ConfigurationProperties("byuhbll.solr")
@Getter
@Setter
public class SolrProperties {
  private boolean enabled = true;
  private boolean initialize = true;
  private List<String> zkHosts = SolrCollectionInitializer.DEFAULT_ZK_HOSTS;
  private String chroot = SolrCollectionInitializer.DEFAULT_CHROOT;
  private List<String> baseUris = List.of();
  private String collectionName;
  private String configsetName;
  private Path configsetPath;
  private String configsetResourceName;
  private Integer shardCount = SolrCollectionInitializer.DEFAULT_SHARD_COUNT;
  private Integer replicaCount = SolrCollectionInitializer.DEFAULT_REPLICA_COUNT;

  /**
   * Use the {@link LBHttp2SolrClient} instead of the {@link CloudSolrClient}. This is best for
   * development and tests.
   */
  private boolean http;
}
