package edu.byu.hbll.solr.batch;

import edu.byu.hbll.misc.BatchExecutorService;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

/** Implementation of {@link BatchExecutorService} that submits documents to Solr for indexing. */
public final class Batcher extends BatchExecutorService<SolrInputDocument, UpdateResponse> {

  private Batcher(Builder builder) {
    super(builder);
  }

  /**
   * Convenience method to submit each {@link SolrInputDocument} in the provided {@link Collection}.
   *
   * @param documents the documents to add to the queue
   * @return List of {@code Future UpdateResponse}
   * @throws InterruptedException if this thread is interrupted
   * @deprecated As of 1.2.0. Use {@link BatchExecutorService#submitAll(Collection)} instead.
   */
  @Deprecated
  public List<Future<UpdateResponse>> submitAllDocuments(
      Collection<? extends SolrInputDocument> documents) throws InterruptedException {
    return super.submitAll(documents);
  }

  /**
   * Configures and builds a new solr {@link Batcher}.
   *
   * @author bwelker
   */
  public static final class Builder extends BatchExecutorService.Builder {

    /**
     * Constructs a new {@code Builder} for a solr {@link Batcher}.
     *
     * @param client The solr client that will be used to communicate with solr.
     */
    public Builder(SolrClient client) {
      super(new BatcherRunnable(client));
    }

    @Override
    public Builder batchCapacity(int batchCapacity) {
      super.batchCapacity(batchCapacity);
      return this;
    }

    @Override
    public Builder batchDelay(Duration batchDelay) {
      super.batchDelay(batchDelay);
      return this;
    }

    @Override
    public Builder queueCapacity(int queueCapacity) {
      super.queueCapacity(queueCapacity);
      return this;
    }

    @Override
    public Builder suspend(Duration suspend) {
      super.suspend(suspend);
      return this;
    }

    @Override
    public Builder threadCount(int threadCount) {
      super.threadCount(threadCount);
      return this;
    }

    @Override
    public Builder threadFactory(ThreadFactory threadFactory) {
      super.threadFactory(threadFactory);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    public Batcher build() {
      return new Batcher(this);
    }
  }
}
