/*
 * Decompiled with CFR 0.152.
 */
package edu.byu.hbll.solr;

import edu.byu.hbll.misc.Resources;
import edu.byu.hbll.solr.CollectionSolrClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.LBHttp2SolrClient;
import org.apache.solr.client.solrj.impl.ZkClientClusterStateProvider;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;

public class SolrCollectionInitializer {
    public static final List<String> DEFAULT_ZK_HOSTS = List.of("localhost");
    public static final String DEFAULT_CHROOT = "/solr";
    public static final int DEFAULT_SHARD_COUNT = 1;
    public static final int DEFAULT_REPLICA_COUNT = 1;
    private List<String> zkHosts = DEFAULT_ZK_HOSTS;
    private String chroot = "/solr";
    private List<String> baseUris = List.of();
    private String collectionName;
    private String configsetName;
    private Path configsetPath;
    private String configsetResourceName;
    private int shardCount = 1;
    private int replicaCount = 1;

    public SolrCollectionInitializer zkHosts(List<String> zkHosts) {
        this.zkHosts = Objects.requireNonNull(zkHosts);
        if (zkHosts.isEmpty()) {
            throw new IllegalArgumentException("Zookeeper Hosts cannot be empty!");
        }
        return this;
    }

    public SolrCollectionInitializer chroot(String chroot) {
        this.chroot = Objects.requireNonNull(chroot);
        return this;
    }

    public SolrCollectionInitializer baseUris(List<String> baseUris) {
        this.baseUris = Objects.requireNonNull(baseUris);
        return this;
    }

    public SolrCollectionInitializer collectionName(String collectionName) {
        this.collectionName = Objects.requireNonNull(collectionName);
        return this;
    }

    public SolrCollectionInitializer configsetName(String configsetName) {
        this.configsetName = configsetName;
        return this;
    }

    public SolrCollectionInitializer configsetPath(Path configsetPath) {
        this.configsetPath = configsetPath;
        return this;
    }

    public SolrCollectionInitializer configsetResourceName(String configsetResourceName) {
        this.configsetResourceName = configsetResourceName;
        return this;
    }

    public SolrCollectionInitializer shardCount(int shardCount) {
        this.shardCount = shardCount;
        if (shardCount < 1) {
            throw new IllegalArgumentException("Shard Count must be greater than 0.");
        }
        return this;
    }

    public SolrCollectionInitializer replicaCount(int replicaCount) {
        this.replicaCount = replicaCount;
        if (replicaCount < 1) {
            throw new IllegalArgumentException("Replica Count must be greater than 0.");
        }
        return this;
    }

    public CloudSolrClient createCloudClient() {
        CloudSolrClient client = !this.baseUris.isEmpty() ? new CloudSolrClient.Builder(this.baseUris).build() : new CloudSolrClient.Builder(this.zkHosts, Optional.ofNullable(this.chroot)).build();
        client.setDefaultCollection(this.collectionName);
        return client;
    }

    public SolrClient createHttpClient() {
        Http2SolrClient httpSolrClient = new Http2SolrClient.Builder().build();
        String[] baseUris = this.baseUris.toArray(new String[0]);
        LBHttp2SolrClient solrClient = new LBHttp2SolrClient(httpSolrClient, baseUris);
        return new CollectionSolrClient((SolrClient)solrClient, this.collectionName);
    }

    public SolrClient initializeHttp() throws IOException, SolrServerException {
        SolrClient client = this.createHttpClient();
        this.initialize(client);
        return client;
    }

    public CloudSolrClient initialize() throws IOException, SolrServerException {
        CloudSolrClient client = this.createCloudClient();
        this.initialize((SolrClient)client);
        return client;
    }

    private void initialize(SolrClient client) throws IOException, SolrServerException {
        Path configsetPath;
        if (this.configsetName == null) {
            this.configsetName = this.collectionName;
        }
        Path path = configsetPath = this.configsetPath == null && this.configsetResourceName != null ? Resources.extract((String)this.configsetResourceName) : this.configsetPath;
        if (configsetPath != null) {
            if (!this.baseUris.isEmpty()) {
                ConfigSetAdminRequest.Upload uploadRequest = new ConfigSetAdminRequest.Upload();
                uploadRequest.setConfigSetName(this.configsetName);
                uploadRequest.setUploadFile(this.zipDirectory(configsetPath).toFile(), "application/zip");
                uploadRequest.setOverwrite(Boolean.valueOf(true));
                uploadRequest.setCleanup(Boolean.valueOf(true));
                client.request((SolrRequest)uploadRequest);
            } else {
                try (ZkClientClusterStateProvider provider = new ZkClientClusterStateProvider(this.zkHosts, this.chroot);){
                    provider.uploadConfig(configsetPath, this.configsetName);
                }
            }
        }
        if (this.collectionName != null) {
            List existingCollectionNames = CollectionAdminRequest.listCollections((SolrClient)client);
            if (existingCollectionNames.contains(this.collectionName)) {
                client.request((SolrRequest)CollectionAdminRequest.reloadCollection((String)this.collectionName));
            } else {
                client.request((SolrRequest)CollectionAdminRequest.createCollection((String)this.collectionName, (String)this.configsetName, (int)this.shardCount, (int)this.replicaCount));
            }
        }
    }

    private Path zipDirectory(Path directory) {
        try {
            Path zipFile = Files.createTempFile("dir.", ".zip", new FileAttribute[0]);
            try (ZipOutputStream archive = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
                Files.walk(directory, new FileVisitOption[0]).filter(p -> !p.equals(directory)).forEach(p -> {
                    try {
                        archive.putNextEntry(new ZipEntry(directory.relativize((Path)p).toString()));
                        if (!Files.isDirectory(p, new LinkOption[0])) {
                            try (InputStream fis = Files.newInputStream(p, new OpenOption[0]);){
                                fis.transferTo(archive);
                            }
                        }
                        archive.closeEntry();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            return zipFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

