/*
 * Decompiled with CFR 0.152.
 */
package edu.byu.hbll.solr;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;

public class SolrDocumentBuilder {
    private static final String MULTIVALUE_SUFFIX = "s";

    public SolrInputDocument buildSolrInputDocument(JsonNode node) {
        return this.buildSolrInputDocument(node, Collections.emptySet());
    }

    public SolrInputDocument buildSolrInputDocument(JsonNode node, Collection<String> ignoreFields) {
        SolrInputDocument solrInputDocument = new SolrInputDocument(new String[0]);
        this.addValues(solrInputDocument, node, "", false, ignoreFields);
        return solrInputDocument;
    }

    private void addValues(SolrInputDocument solrInputDocument, JsonNode node, String name, boolean multivalued, Collection<String> ignoreFields) {
        if (ignoreFields.contains(name)) {
            return;
        }
        if (node.isValueNode()) {
            this.addValues(solrInputDocument, node, name, multivalued);
        } else if (node.isArray()) {
            node.forEach(element -> this.addValues(solrInputDocument, (JsonNode)element, name, true, ignoreFields));
        } else if (node.isObject()) {
            Iterator it = node.fieldNames();
            while (it.hasNext()) {
                String fieldName = (String)it.next();
                JsonNode child = node.get(fieldName);
                this.addValues(solrInputDocument, child, this.buildName(name, fieldName), multivalued, ignoreFields);
            }
        }
    }

    private void addValues(SolrInputDocument doc, JsonNode node, String name, boolean multivalued) {
        String suffix = "_s";
        if (node.isBoolean()) {
            suffix = "_b";
        } else if (node.isNumber()) {
            suffix = "_d";
        } else if (this.isInstant(node.asText())) {
            suffix = "_dt";
        }
        this.addField(doc, name, multivalued, node.asText(), suffix);
    }

    private void addField(SolrInputDocument doc, String name, boolean multivalued, String value, String type) {
        if (multivalued) {
            doc.addField(name + type + MULTIVALUE_SUFFIX, (Object)value);
        } else {
            doc.addField(name + type, (Object)value);
        }
    }

    private boolean isInstant(String value) {
        try {
            Instant.parse(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String buildName(String name, String field) {
        if (name.isEmpty()) {
            return field;
        }
        return name + "_" + field;
    }

    public void addCustomStringFields(Map<String, String> valueMap, SolrInputDocument document) {
        valueMap.forEach((key, value) -> document.addField(key, value));
    }

    public void addCustomIntegerFields(Map<String, Integer> valueMap, SolrInputDocument document) {
        valueMap.forEach((key, value) -> document.addField(key, value));
    }

    public void addCustomBooleanFields(Map<String, Boolean> valueMap, SolrInputDocument document) {
        valueMap.forEach((key, value) -> document.addField(key, value));
    }

    public void addCustomLongFields(Map<String, Long> valueMap, SolrInputDocument document) {
        valueMap.forEach((key, value) -> document.addField(key, value));
    }
}

