/*
 * Decompiled with CFR 0.152.
 */
package edu.byu.hbll.solr.auto;

import edu.byu.hbll.solr.SolrCollectionInitializer;
import edu.byu.hbll.solr.auto.SolrProperties;
import java.io.IOException;
import javax.annotation.PreDestroy;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SolrProperties.class})
public class SolrAutoConfiguration {
    private SolrProperties properties;
    private SolrClient solrClient;

    public SolrAutoConfiguration(SolrProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SolrClient client() throws IOException, SolrServerException {
        if (!this.properties.isEnabled()) {
            return null;
        }
        SolrCollectionInitializer initializer = new SolrCollectionInitializer().zkHosts(this.properties.getZkHosts()).chroot(this.properties.getChroot()).baseUris(this.properties.getBaseUris()).collectionName(this.properties.getCollectionName()).configsetName(this.properties.getConfigsetName()).configsetPath(this.properties.getConfigsetPath()).configsetResourceName(this.properties.getConfigsetResourceName()).shardCount(this.properties.getShardCount()).replicaCount(this.properties.getReplicaCount());
        if (this.properties.isInitialize()) {
            if (this.properties.isHttp()) {
                return initializer.initializeHttp();
            }
            return initializer.initialize();
        }
        if (this.properties.isHttp()) {
            return initializer.createHttpClient();
        }
        return initializer.createCloudClient();
    }

    @PreDestroy
    public void preDestroy() throws IOException {
        if (this.solrClient != null) {
            this.solrClient.close();
        }
    }
}

