/*
 * Decompiled with CFR 0.152.
 */
package edu.byu.hbll.solr.batch;

import edu.byu.hbll.misc.BatchRunnable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatcherRunnable
implements BatchRunnable<SolrInputDocument, UpdateResponse> {
    private static final Logger logger = LoggerFactory.getLogger(BatcherRunnable.class);
    private SolrClient client;

    BatcherRunnable(SolrClient client) {
        Objects.requireNonNull(client);
        this.client = client;
    }

    public List<UpdateResponse> run(List<SolrInputDocument> docs) {
        UpdateResponse response = null;
        try {
            response = this.client.add(docs);
        }
        catch (IOException | SolrServerException e) {
            logger.error(e.toString(), e);
        }
        return Collections.nCopies(docs.size(), response);
    }
}

