/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp;

import cmu.arktweetnlp.Twokenize;
import cmu.arktweetnlp.impl.Model;
import cmu.arktweetnlp.impl.ModelSentence;
import cmu.arktweetnlp.impl.Sentence;
import cmu.arktweetnlp.impl.features.FeatureExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Tagger {
    public Model model;
    public FeatureExtractor featureExtractor;

    public void loadModel(String string) throws IOException {
        this.model = Model.loadModelFromText(string);
        this.featureExtractor = new FeatureExtractor(this.model, false);
    }

    public List<TaggedToken> tokenizeAndTag(String string) {
        if (this.model == null) {
            throw new RuntimeException("Must loadModel() first before tagging anything");
        }
        List<String> list = Twokenize.tokenizeRawTweetText(string);
        Sentence sentence = new Sentence();
        sentence.tokens = list;
        ModelSentence modelSentence = new ModelSentence(sentence.T());
        this.featureExtractor.computeFeatures(sentence, modelSentence);
        this.model.greedyDecode(modelSentence, false);
        ArrayList<TaggedToken> arrayList = new ArrayList<TaggedToken>();
        for (int i = 0; i < sentence.T(); ++i) {
            TaggedToken taggedToken = new TaggedToken();
            taggedToken.token = list.get(i);
            taggedToken.tag = this.model.labelVocab.name(modelSentence.labels[i]);
            arrayList.add(taggedToken);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            System.out.println("Supply the model filename as first argument.");
        }
        String string = stringArray[0];
        Tagger tagger = new Tagger();
        tagger.loadModel(string);
        String string2 = "RT @DjBlack_Pearl: wat muhfuckaz wearin 4 the lingerie party?????";
        List<TaggedToken> list = tagger.tokenizeAndTag(string2);
        for (TaggedToken taggedToken : list) {
            System.out.printf("%s\t%s\n", taggedToken.tag, taggedToken.token);
        }
    }

    public static class TaggedToken {
        public String token;
        public String tag;
    }
}

