/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class Twokenize {
    static Pattern Contractions = Pattern.compile("(?i)(\\w+)(n['\u2019\u2032]t|['\u2019\u2032]ve|['\u2019\u2032]ll|['\u2019\u2032]d|['\u2019\u2032]re|['\u2019\u2032]s|['\u2019\u2032]m)$");
    static Pattern Whitespace = Pattern.compile("[\\s\\p{Zs}]+");
    static String punctChars = "['\"\u201c\u201d\u2018\u2019.?!\u2026,:;]";
    static String punctSeq = "['\"\u201c\u201d\u2018\u2019]+|[.?!,\u2026]+|[:;]+";
    static String entity = "&(?:amp|lt|gt|quot);";
    static String urlStart1 = "(?:https?://|\\bwww\\.)";
    static String commonTLDs = "(?:com|org|edu|gov|net|mil|aero|asia|biz|cat|coop|info|int|jobs|mobi|museum|name|pro|tel|travel|xxx)";
    static String ccTLDs = "(?:ac|ad|ae|af|ag|ai|al|am|an|ao|aq|ar|as|at|au|aw|ax|az|ba|bb|bd|be|bf|bg|bh|bi|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|cr|cs|cu|cv|cx|cy|cz|dd|de|dj|dk|dm|do|dz|ec|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gg|gh|gi|gl|gm|gn|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|im|in|io|iq|ir|is|it|je|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|me|mg|mh|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|mv|mw|mx|my|mz|na|nc|ne|nf|ng|ni|nl|no|np|nr|nu|nz|om|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|ps|pt|pw|py|qa|re|ro|rs|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|ss|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tl|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|za|zm|zw)";
    static String urlStart2 = "\\b(?:[A-Za-z\\d-])+(?:\\.[A-Za-z0-9]+){0,3}\\.(?:" + commonTLDs + "|" + ccTLDs + ")" + "(?:\\." + ccTLDs + ")?(?=\\W|$)";
    static String urlBody = "(?:[^\\.\\s<>][^\\s<>]*?)?";
    static String urlExtraCrapBeforeEnd = "(?:" + punctChars + "|" + entity + ")+?";
    static String urlEnd = "(?:\\.\\.+|[<>]|\\s|$)";
    public static String url = "(?:" + urlStart1 + "|" + urlStart2 + ")" + urlBody + "(?=(?:" + urlExtraCrapBeforeEnd + ")?" + urlEnd + ")";
    static String timeLike = "\\d+(?::\\d+){1,2}";
    static String numberWithCommas = "(?:(?<!\\d)\\d{1,3},)+?\\d{3}(?=(?:[^,\\d]|$))";
    static String numComb = "\\p{Sc}?\\d+(?:\\.\\d+)+%?";
    static String boundaryNotDot = "(?:$|\\s|[\u201c\\u0022?!,:;]|" + entity + ")";
    static String aa1 = "(?:[A-Za-z]\\.){2,}(?=" + boundaryNotDot + ")";
    static String aa2 = "[^A-Za-z](?:[A-Za-z]\\.){1,}[A-Za-z](?=" + boundaryNotDot + ")";
    static String standardAbbreviations = "\\b(?:[Mm]r|[Mm]rs|[Mm]s|[Dd]r|[Ss]r|[Jj]r|[Rr]ep|[Ss]en|[Ss]t)\\.";
    static String arbitraryAbbrev = "(?:" + aa1 + "|" + aa2 + "|" + standardAbbreviations + ")";
    static String separators = "(?:--+|\u2015|\u2014|~|\u2013|=)";
    static String decorations = "(?:[\u266b\u266a]+|[\u2605\u2606]+|[\u2665\u2764\u2661]+|[\\u2639-\\u263b]+|[\\ue001-\\uebbb]+)";
    static String thingsThatSplitWords = "[^\\s\\.,?\"]";
    static String embeddedApostrophe = thingsThatSplitWords + "+['\u2019\u2032]" + thingsThatSplitWords + "*";
    static String normalEyes = "(?iu)[:=]";
    static String wink = "[;]";
    static String noseArea = "(?:|-|[^a-zA-Z0-9 ])";
    static String happyMouths = "[D\\)\\]\\}]+";
    static String sadMouths = "[\\(\\[\\{]+";
    static String tongue = "[pPd3]+";
    static String otherMouths = "(?:[oO]+|[/\\\\]+|[vV]+|[Ss]+|[|]+)";
    static String bfLeft = "(\u2665|0|o|\u00b0|v|\\$|t|x|;|\\u0CA0|@|\u0298|\u2022|\u30fb|\u25d5|\\^|\u00ac|\\*)";
    static String bfCenter = "(?:[\\.]|[_-]+)";
    static String bfRight = "\\2";
    static String s3 = "(?:--['\"])";
    static String s4 = "(?:<|&lt;|>|&gt;)[\\._-]+(?:<|&lt;|>|&gt;)";
    static String s5 = "(?:[.][_]+[.])";
    static String basicface = "(?:(?i)" + bfLeft + bfCenter + bfRight + ")|" + s3 + "|" + s4 + "|" + s5;
    static String eeLeft = "[\uff3c\\\\\u01aa\u0504\\(\uff08<>;\u30fd\\-=~\\*]+";
    static String eeRight = "[\\-=\\);'\\u0022<>\u0283\uff09/\uff0f\u30ce\uff89\u4e3f\u256f\u03c3\u3063\u00b5~\\*]+";
    static String eeSymbol = "[^A-Za-z0-9\\s\\(\\)\\*:=-]";
    static String eastEmote = eeLeft + "(?:" + basicface + "|" + eeSymbol + ")+" + eeRight;
    public static String emoticon = Twokenize.OR("(?:>|&gt;)?" + Twokenize.OR(normalEyes, wink) + Twokenize.OR(noseArea, "[Oo]") + Twokenize.OR(tongue + "(?=\\W|$|RT|rt|Rt)", otherMouths + "(?=\\W|$|RT|rt|Rt)", sadMouths, happyMouths), "(?<=(?: |^))" + Twokenize.OR(sadMouths, happyMouths, otherMouths) + noseArea + Twokenize.OR(normalEyes, wink) + "(?:<|&lt;)?", eastEmote.replaceFirst("2", "1"), basicface);
    static String Hearts = "(?:<+/?3+)+";
    static String Arrows = "(?:<*[-\u2015\u2014=]*>+|<+[-\u2015\u2014=]*>*)|\\p{InArrows}+";
    static String Hashtag = "#[a-zA-Z0-9_]+";
    static String AtMention = "[@\uff20][a-zA-Z0-9_]+";
    static String Bound = "(?:\\W|^|$)";
    public static String Email = "(?<=" + Bound + ")[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}(?=" + Bound + ")";
    static Pattern Protected = Pattern.compile(Twokenize.OR(Hearts, url, Email, timeLike, numberWithCommas, numComb, emoticon, Arrows, entity, punctSeq, arbitraryAbbrev, separators, decorations, embeddedApostrophe, Hashtag, AtMention));
    static String edgePunctChars = "'\"\u201c\u201d\u2018\u2019\u00ab\u00bb{}\\(\\)\\[\\]\\*&";
    static String edgePunct = "[" + edgePunctChars + "]";
    static String notEdgePunct = "[a-zA-Z0-9]";
    static String offEdge = "(^|$|:|;|\\s|\\.|,)";
    static Pattern EdgePunctLeft = Pattern.compile(offEdge + "(" + edgePunct + "+)(" + notEdgePunct + ")");
    static Pattern EdgePunctRight = Pattern.compile("(" + notEdgePunct + ")(" + edgePunct + "+)" + offEdge);

    public static String OR(String ... stringArray) {
        String string = "(?:";
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            stringBuilder.append(string);
            string = "|";
            stringBuilder.append(string2);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String splitEdgePunct(String string) {
        Matcher matcher = EdgePunctLeft.matcher(string);
        string = matcher.replaceAll("$1$2 $3");
        matcher = EdgePunctRight.matcher(string);
        string = matcher.replaceAll("$1 $2$3");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static List<String> simpleTokenize(String string) {
        void var8_12;
        int n;
        void list;
        ArrayList<Object> arrayList;
        String string2 = Twokenize.splitEdgePunct(string);
        int n2 = string2.length();
        Matcher matcher = Protected.matcher(string2);
        ArrayList arrayList2 = new ArrayList();
        ArrayList<Pair<Integer, Integer>> arrayList3 = new ArrayList<Pair<Integer, Integer>>();
        while (matcher.find()) {
            if (matcher.start() == matcher.end()) continue;
            arrayList = new ArrayList<Object>(1);
            arrayList.add(string2.substring(matcher.start(), matcher.end()));
            arrayList2.add(arrayList);
            arrayList3.add(new Pair<Integer, Integer>(matcher.start(), matcher.end()));
        }
        arrayList = new ArrayList(2 + 2 * arrayList3.size());
        arrayList.add(0);
        for (Pair pair : arrayList3) {
            arrayList.add(pair.first);
            arrayList.add(pair.second);
        }
        arrayList.add(n2);
        ArrayList arrayList4 = new ArrayList(arrayList.size() / 2);
        boolean i = false;
        while (list < arrayList.size()) {
            String string3 = string2.substring((Integer)arrayList.get((int)list), (Integer)arrayList.get((int)(list + true)));
            List<String> list2 = Arrays.asList(string3.trim().split(" "));
            arrayList4.add(list2);
            list += 2;
        }
        ArrayList arrayList5 = new ArrayList();
        for (n = 0; n < arrayList2.size(); ++n) {
            List<String> list4 = Twokenize.addAllnonempty((List<String>)var8_12, (List)arrayList4.get(n));
            list4 = Twokenize.addAllnonempty(list4, (List)arrayList2.get(n));
        }
        List<String> list5 = Twokenize.addAllnonempty((List<String>)var8_12, (List)arrayList4.get(n));
        return list5;
    }

    private static List<String> addAllnonempty(List<String> list, List<String> list2) {
        for (String string : list2) {
            String string2 = string.trim();
            if (string2.length() <= 0) continue;
            list.add(string2);
        }
        return list;
    }

    public static String squeezeWhitespace(String string) {
        return Whitespace.matcher(string).replaceAll(" ").trim();
    }

    private static List<String> splitToken(String string) {
        Matcher matcher = Contractions.matcher(string);
        if (matcher.find()) {
            String[] stringArray = new String[]{matcher.group(1), matcher.group(2)};
            return Arrays.asList(stringArray);
        }
        String[] stringArray = new String[]{string};
        return Arrays.asList(stringArray);
    }

    public static List<String> tokenize(String string) {
        return Twokenize.simpleTokenize(Twokenize.squeezeWhitespace(string));
    }

    public static String normalizeTextForTagger(String string) {
        string = string.replaceAll("&amp;", "&");
        string = StringEscapeUtils.unescapeHtml((String)string);
        return string;
    }

    public static List<String> tokenizeRawTweetText(String string) {
        List<String> list = Twokenize.tokenize(Twokenize.normalizeTextForTagger(string));
        return list;
    }

    private static class Pair<T1, T2> {
        public T1 first;
        public T2 second;

        public Pair(T1 T1, T2 T2) {
            this.first = T1;
            this.second = T2;
        }
    }
}

