/*
 * Decompiled with CFR 0.152.
 */
package cmu.arktweetnlp.impl;

import cmu.arktweetnlp.impl.OWLQN;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.optimization.DiffFunction;
import java.util.LinkedList;

class OptimizerState {
    double[] x;
    double[] grad;
    double[] newX;
    double[] newGrad;
    double[] dir;
    double[] steepestDescDir;
    LinkedList<double[]> sList = new LinkedList();
    LinkedList<double[]> yList = new LinkedList();
    LinkedList<Double> roList = new LinkedList();
    double[] alphas;
    double value;
    int iter;
    int m;
    int dim;
    DiffFunction func;
    double l1weight;
    boolean quiet;

    private String arrayToString(double[] dArray) {
        String string = "";
        for (int i = 0; i < dArray.length; ++i) {
            if (i > 0) {
                string = string + "\t";
            }
            string = string + dArray[i];
        }
        return string;
    }

    private void printStateValues() {
        int n;
        System.err.println("\nSLIST:");
        for (n = 0; n < this.sList.size(); ++n) {
            System.err.println(this.arrayToString(this.sList.get(n)));
        }
        System.err.println("YLIST:");
        for (n = 0; n < this.yList.size(); ++n) {
            System.err.println(this.arrayToString(this.yList.get(n)));
        }
        System.err.println("ROLIST:");
        for (n = 0; n < this.roList.size(); ++n) {
            System.err.println(this.roList.get(n));
        }
        System.err.println();
    }

    void mapDirByInverseHessian() {
        int n = this.sList.size();
        if (n != 0) {
            for (int i = n - 1; i >= 0; --i) {
                this.alphas[i] = -ArrayMath.innerProduct((double[])this.sList.get(i), (double[])this.dir) / this.roList.get(i);
                ArrayMath.addMultInPlace((double[])this.dir, (double[])this.yList.get(i), (double)this.alphas[i]);
            }
            double[] dArray = this.yList.get(n - 1);
            double d = ArrayMath.innerProduct((double[])dArray, (double[])dArray);
            double d2 = this.roList.get(n - 1) / d;
            ArrayMath.multiplyInPlace((double[])this.dir, (double)d2);
            for (int i = 0; i < n; ++i) {
                double d3 = ArrayMath.innerProduct((double[])this.yList.get(i), (double[])this.dir) / this.roList.get(i);
                ArrayMath.addMultInPlace((double[])this.dir, (double[])this.sList.get(i), (double)(-this.alphas[i] - d3));
            }
        }
    }

    void makeSteepestDescDir() {
        if (this.l1weight == 0.0) {
            ArrayMath.multiplyInto((double[])this.dir, (double[])this.grad, (double)-1.0);
        } else {
            for (int i = 0; i < this.dim; ++i) {
                this.dir[i] = OWLQN.biasParameters.contains(i) ? -this.grad[i] : (this.x[i] < 0.0 ? -this.grad[i] + this.l1weight : (this.x[i] > 0.0 ? -this.grad[i] - this.l1weight : (this.grad[i] < -this.l1weight ? -this.grad[i] - this.l1weight : (this.grad[i] > this.l1weight ? -this.grad[i] + this.l1weight : 0.0))));
            }
        }
        this.steepestDescDir = (double[])this.dir.clone();
    }

    void fixDirSigns() {
        if (this.l1weight > 0.0) {
            for (int i = 0; i < this.dim; ++i) {
                if (OWLQN.biasParameters.contains(i) || !(this.dir[i] * this.steepestDescDir[i] <= 0.0)) continue;
                this.dir[i] = 0.0;
            }
        }
    }

    void updateDir() {
        this.makeSteepestDescDir();
        this.mapDirByInverseHessian();
        this.fixDirSigns();
    }

    double dirDeriv() {
        if (this.l1weight == 0.0) {
            return ArrayMath.innerProduct((double[])this.dir, (double[])this.grad);
        }
        double d = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            if (OWLQN.biasParameters.contains(i)) {
                d += this.dir[i] * this.grad[i];
                continue;
            }
            if (this.dir[i] == 0.0) continue;
            if (this.x[i] < 0.0) {
                d += this.dir[i] * (this.grad[i] - this.l1weight);
                continue;
            }
            if (this.x[i] > 0.0) {
                d += this.dir[i] * (this.grad[i] + this.l1weight);
                continue;
            }
            if (this.dir[i] < 0.0) {
                d += this.dir[i] * (this.grad[i] - this.l1weight);
                continue;
            }
            if (!(this.dir[i] > 0.0)) continue;
            d += this.dir[i] * (this.grad[i] + this.l1weight);
        }
        return d;
    }

    private boolean getNextPoint(double d) {
        ArrayMath.addMultInto((double[])this.newX, (double[])this.x, (double[])this.dir, (double)d);
        if (this.l1weight > 0.0) {
            for (int i = 0; i < this.dim; ++i) {
                if (OWLQN.biasParameters.contains(i) || !(this.x[i] * this.newX[i] < 0.0)) continue;
                this.newX[i] = 0.0;
            }
        }
        return true;
    }

    double evalL1() {
        double d = this.func.valueAt(this.newX);
        this.newGrad = (double[])this.func.derivativeAt(this.newX).clone();
        if (this.l1weight > 0.0) {
            for (int i = 0; i < this.dim; ++i) {
                if (OWLQN.biasParameters.contains(i)) continue;
                d += Math.abs(this.newX[i]) * this.l1weight;
            }
        }
        return d;
    }

    void backTrackingLineSearch() {
        double d;
        double d2 = this.dirDeriv();
        if (d2 >= 0.0) {
            throw new RuntimeException("L-BFGS chose a non-descent direction: check your gradient!");
        }
        double d3 = 1.0;
        double d4 = 0.5;
        if (this.iter == 1) {
            d = Math.sqrt(ArrayMath.innerProduct((double[])this.dir, (double[])this.dir));
            d3 = 1.0 / d;
            d4 = 0.1;
        }
        d = 1.0E-4;
        double d5 = this.value;
        while (true) {
            this.getNextPoint(d3);
            this.value = this.evalL1();
            if (this.value <= d5 + d * d2 * d3) break;
            if (d3 < 1.0E-30) {
                System.err.println("Warning: The line search backed off to alpha < 1e-30, and stayed with the current parameter values.  This probably means converged has been reached.");
                this.value = d5;
                break;
            }
            if (!this.quiet) {
                System.err.print(".");
            }
            d3 *= d4;
        }
        if (!this.quiet) {
            System.err.println();
        }
    }

    void shift() {
        double[] dArray = null;
        double[] dArray2 = null;
        int n = this.sList.size();
        if (n < this.m) {
            try {
                dArray = new double[this.dim];
                dArray2 = new double[this.dim];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.m = n;
                dArray = null;
            }
        }
        if (dArray == null) {
            dArray = this.sList.poll();
            dArray2 = this.yList.poll();
            this.roList.poll();
        }
        ArrayMath.addMultInto((double[])dArray, (double[])this.newX, (double[])this.x, (double)-1.0);
        ArrayMath.addMultInto((double[])dArray2, (double[])this.newGrad, (double[])this.grad, (double)-1.0);
        double d = ArrayMath.innerProduct((double[])dArray, (double[])dArray2);
        assert (d != 0.0);
        this.sList.offer(dArray);
        this.yList.offer(dArray2);
        this.roList.offer(d);
        double[] dArray3 = this.newX;
        this.newX = this.x;
        this.x = dArray3;
        double[] dArray4 = this.newGrad;
        this.newGrad = this.grad;
        this.grad = dArray4;
        ++this.iter;
    }

    double getValue() {
        return this.value;
    }

    OptimizerState(DiffFunction diffFunction, double[] dArray, int n, double d, boolean bl) {
        this.x = dArray;
        this.grad = new double[dArray.length];
        this.newX = (double[])dArray.clone();
        this.newGrad = new double[dArray.length];
        this.dir = new double[dArray.length];
        this.steepestDescDir = (double[])this.newGrad.clone();
        this.alphas = new double[n];
        this.iter = 1;
        this.m = n;
        this.dim = dArray.length;
        this.func = diffFunction;
        this.l1weight = d;
        this.quiet = bl;
        if (n <= 0) {
            throw new RuntimeException("m must be an integer greater than zero.");
        }
        this.value = this.evalL1();
        this.grad = (double[])this.newGrad.clone();
    }
}

